/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.dashbuilder.scheduler.PausableThreadPoolExecutor;
import org.dashbuilder.scheduler.SchedulerTask;
import org.dashbuilder.scheduler.SchedulerThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final String TASK = "Task ";
    private Logger log = LoggerFactory.getLogger(Scheduler.class);
    protected PausableThreadPoolExecutor executor;
    protected ThreadFactory threadFactory;
    protected Map<String, SchedulerTask> scheduledTasks = Collections.synchronizedMap(new HashMap());
    protected int maxThreadPoolSize;

    public void init(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
        this.threadFactory = new SchedulerThreadFactory();
        this.executor = new PausableThreadPoolExecutor(maxThreadPoolSize, this.threadFactory);
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.log.debug("Scheduler started [pool size=" + maxThreadPoolSize + "].");
    }

    public void shutdown() {
        this.log.debug("Scheduler shutdown started.");
        this.executor.shutdown();
        this.log.debug("Scheduler shutdown completed.");
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
        if (this.executor != null) {
            this.executor.setCorePoolSize(maxThreadPoolSize);
        }
    }

    public int getThreadPoolSize() {
        return this.executor.getPoolSize();
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getNumberOfScheduledTasks() {
        return this.scheduledTasks.size();
    }

    public int getNumberOfScheduledTasksInQueue() {
        return this.executor.getQueue().size();
    }

    public SchedulerTask getTaskByKey(String key) {
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (!task.getKey().equals(key)) continue;
            return task;
        }
        return null;
    }

    public List<SchedulerTask> getScheduledTasks() {
        return new ArrayList<SchedulerTask>(this.scheduledTasks.values());
    }

    public List<SchedulerTask> getRunningTasks() {
        ArrayList<SchedulerTask> result = new ArrayList<SchedulerTask>();
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (!task.isRunning()) continue;
            result.add(task);
        }
        return result;
    }

    public List<SchedulerTask> getMisfiredTasks() {
        ArrayList<SchedulerTask> result = new ArrayList<SchedulerTask>();
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (!task.isMisfired()) continue;
            result.add(task);
        }
        return result;
    }

    public List<SchedulerTask> getWaitingTasks() {
        ArrayList<SchedulerTask> result = new ArrayList<SchedulerTask>();
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (task.isDone() || task.isRunning() || task.isMisfired()) continue;
            result.add(task);
        }
        return result;
    }

    public void pause() {
        this.executor.pause();
    }

    public void resume() {
        this.executor.resume();
    }

    public boolean isPaused() {
        return this.executor.isPaused();
    }

    public synchronized void execute(SchedulerTask task) {
        try {
            this._schedule(task, null);
        }
        catch (Exception e) {
            this.log.error("Execute call failed for task: " + task.getKey(), (Throwable)e);
        }
    }

    public synchronized void schedule(SchedulerTask task, Date date) {
        try {
            this._schedule(task, date);
        }
        catch (Exception e) {
            this.log.error("Schedule call failed for task: " + task.getKey(), (Throwable)e);
        }
    }

    public synchronized void schedule(SchedulerTask task, long seconds) {
        try {
            this._schedule(task, seconds);
        }
        catch (Exception e) {
            this.log.error("Schedule call failed for task: " + task.getKey(), (Throwable)e);
        }
    }

    public synchronized void unschedule(String key) {
        try {
            this._unschedule(key);
        }
        catch (Exception e) {
            this.log.error("Unschedule call failed for task: " + key, (Throwable)e);
        }
    }

    public synchronized void unscheduleAll() {
        try {
            this._unscheduleAll();
        }
        catch (Exception e) {
            this.log.error("Unschedule all call failed.", (Throwable)e);
        }
    }

    public synchronized void fireTask(String key) {
        SchedulerTask task = this.scheduledTasks.get(key);
        if (task != null && !task.isDone() && !task.isRunning()) {
            try {
                task.run();
                this.log.debug(TASK + task + " executed.");
            }
            finally {
                this.scheduledTasks.remove(key);
                task.cancel();
                this._purge();
                if (task.isFixedDelay()) {
                    this.schedule(task, task.getFixedDelaySeconds());
                }
            }
        }
    }

    protected void _schedule(SchedulerTask task, Date date) {
        long delay = 10000L;
        if (date != null) {
            Date now = new Date();
            delay = date.getTime() - now.getTime();
            if (delay <= 0L) {
                throw new IllegalArgumentException("Delay is negative. The task can not be scheduled [" + task.toString() + "] Date=" + date);
            }
        }
        this._unschedule(task.getKey());
        task.future = this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
        this.scheduledTasks.put(task.getKey(), task);
        if (date == null) {
            this.log.debug(TASK + task + " execution requested.");
        } else {
            this.log.debug(TASK + task + " scheduled to: " + date);
        }
    }

    protected void _schedule(SchedulerTask task, long seconds) {
        this._unschedule(task.getKey());
        task.fixedDelay = true;
        task.fixedDelaySeconds = seconds;
        task.future = this.executor.scheduleWithFixedDelay(task, seconds, seconds, TimeUnit.SECONDS);
        this.scheduledTasks.put(task.getKey(), task);
        this.log.debug(TASK + task + " scheduled every " + seconds + " seconds.");
    }

    protected void _unschedule(String key) {
        SchedulerTask task = this.scheduledTasks.remove(key);
        if (task != null && !task.isDone() && !task.isRunning()) {
            task.cancel();
            this._purge();
            this.log.debug(TASK + task + " unscheduled.");
        }
    }

    public void _unscheduleAll() {
        Collection<SchedulerTask> tasks = this.scheduledTasks.values();
        for (SchedulerTask task : tasks) {
            if (task == null || task.isDone() || task.isRunning()) continue;
            task.cancel();
        }
        this.executor.purge();
        this.scheduledTasks.clear();
        this.log.debug("All tasks unscheduled.");
    }

    protected void _purge() {
        this.executor.purge();
        Iterator<SchedulerTask> it = this.scheduledTasks.values().iterator();
        while (it.hasNext()) {
            SchedulerTask task = it.next();
            if (!task.isDone()) continue;
            it.remove();
            this.log.debug(TASK + task + " purged.");
        }
    }

    public String printScheduledTasksReport() {
        HashMap<String, SchedulerTask> temp = new HashMap<String, SchedulerTask>(this.scheduledTasks);
        StringBuilder buf = new StringBuilder();
        buf.append("\n\n------------------ SCHEDULED TASKS=").append(temp.size()).append(" (Queue size=").append(this.executor.getQueue().size()).append(") -----------------------------\n");
        for (Map.Entry entry : temp.entrySet()) {
            SchedulerTask task = (SchedulerTask)entry.getValue();
            buf.append("\n");
            if (task.isRunning()) {
                buf.append("RUNNING - ");
            } else if (task.isCancelled()) {
                buf.append("CANCELL - ");
            } else if (task.isDone()) {
                buf.append("COMPLTD - ");
            } else {
                buf.append("WAITING - [Firing in ").append(task.printTimeToFire()).append("] - ");
            }
            buf.append("[").append(task).append("]");
        }
        return buf.toString();
    }
}

