/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;

public class DriverManagerConnectionFactory
implements ConnectionFactory {
    private final String connectionUri;
    private String userName;
    private String userPassword;
    private Properties properties;

    public DriverManagerConnectionFactory(String connectionUri) {
        this.connectionUri = connectionUri;
        this.properties = new Properties();
    }

    public DriverManagerConnectionFactory(String connectionUri, Properties properties) {
        this.connectionUri = connectionUri;
        this.properties = properties;
    }

    public DriverManagerConnectionFactory(String connectionUri, String userName, String userPassword) {
        this.connectionUri = connectionUri;
        this.userName = userName;
        this.userPassword = userPassword;
    }

    @Override
    public Connection createConnection() throws SQLException {
        if (null == this.properties) {
            if (this.userName == null && this.userPassword == null) {
                return DriverManager.getConnection(this.connectionUri);
            }
            return DriverManager.getConnection(this.connectionUri, this.userName, this.userPassword);
        }
        return DriverManager.getConnection(this.connectionUri, this.properties);
    }

    static {
        DriverManager.getDrivers();
    }
}

