/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDescriptorManagerUtil {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDescriptorManagerUtil.class);

    public static List<DeploymentDescriptor> getDeploymentDescriptorHierarchy(DeploymentDescriptorManager manager, KieContainer kieContainer) {
        ArrayList<DeploymentDescriptor> descriptorHierarchy = new ArrayList<DeploymentDescriptor>();
        if (((KieContainerImpl)kieContainer).getKieProject() instanceof KieModuleKieProject) {
            InternalKieModule module = ((KieModuleKieProject)((KieContainerImpl)kieContainer).getKieProject()).getInternalKieModule();
            DeploymentDescriptorManagerUtil.collectDeploymentDescriptors(module, descriptorHierarchy);
        }
        descriptorHierarchy.add(manager.getDefaultDescriptor());
        return descriptorHierarchy;
    }

    protected static void collectDeploymentDescriptors(InternalKieModule kmodule, List<DeploymentDescriptor> descriptorHierarchy) {
        DeploymentDescriptor descriptor = DeploymentDescriptorManagerUtil.getDescriptorFromKModule(kmodule);
        if (descriptor != null) {
            descriptorHierarchy.add(descriptor);
        }
        if (kmodule.getKieDependencies() != null) {
            Collection depModules = kmodule.getKieDependencies().values();
            for (InternalKieModule depModule : depModules) {
                DeploymentDescriptorManagerUtil.collectDeploymentDescriptors(depModule, descriptorHierarchy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DeploymentDescriptor getDescriptorFromKModule(InternalKieModule kmodule) {
        DeploymentDescriptor desc = null;
        if (kmodule.isAvailable("META-INF/kie-deployment-descriptor.xml")) {
            byte[] content = kmodule.getBytes("META-INF/kie-deployment-descriptor.xml");
            ByteArrayInputStream input = new ByteArrayInputStream(content);
            try {
                desc = DeploymentDescriptorIO.fromXml((InputStream)input);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.debug("Error when closing stream of kie-deployment-descriptor.xml");
                }
            }
        }
        return desc;
    }
}

