/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.def;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefDbSQLValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefDbTableValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefValidation;

public class SQLDataSetDef
extends DataSetDef {
    @NotNull(groups={SQLDataSetDefValidation.class})
    @Size(min=1, groups={SQLDataSetDefValidation.class})
    protected String dataSource;
    protected String dbSchema;
    @NotNull(groups={SQLDataSetDefDbTableValidation.class})
    @Size(min=1, groups={SQLDataSetDefDbTableValidation.class})
    protected String dbTable;
    @NotNull(groups={SQLDataSetDefDbSQLValidation.class})
    @Size(min=1, groups={SQLDataSetDefDbSQLValidation.class})
    protected String dbSQL;
    protected boolean estimateSize = true;

    public SQLDataSetDef() {
        super.setProvider(DataSetProviderType.SQL);
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDbTable() {
        return this.dbTable;
    }

    public void setDbTable(String dbTable) {
        this.dbTable = dbTable;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public String getDbSQL() {
        return this.dbSQL;
    }

    public void setDbSQL(String dbSQL) {
        this.dbSQL = dbSQL;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    @Override
    public Integer getCacheMaxRows() {
        return this.cacheMaxRows;
    }

    @Override
    public void setCacheMaxRows(Integer cacheMaxRows) {
        this.cacheMaxRows = cacheMaxRows;
    }

    public void setEstimateSize(boolean estimateSize) {
        this.estimateSize = estimateSize;
    }

    public boolean isEstimateSize() {
        return this.estimateSize;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            SQLDataSetDef other = (SQLDataSetDef)obj;
            if (!super.equals(other)) {
                return false;
            }
            if (this.dataSource != null && !this.dataSource.equals(other.dataSource)) {
                return false;
            }
            if (this.dbSchema != null && !this.dbSchema.equals(other.dbSchema)) {
                return false;
            }
            if (this.dbTable != null && !this.dbTable.equals(other.dbTable)) {
                return false;
            }
            if (this.dbSQL != null && !this.dbSQL.equals(other.dbSQL)) {
                return false;
            }
            return this.estimateSize == other.estimateSize;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataSource, this.dbSchema, this.dbTable, this.dbSQL);
    }

    @Override
    public DataSetDef clone() {
        SQLDataSetDef def = new SQLDataSetDef();
        this.clone(def);
        def.setDataSource(this.getDataSource());
        def.setDbSchema(this.getDbSchema());
        def.setDbTable(this.getDbTable());
        def.setDbSQL(this.getDbSQL());
        def.setEstimateSize(this.isEstimateSize());
        return def;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("UUID=").append(this.UUID).append("\n");
        out.append("Provider=").append(this.provider).append("\n");
        out.append("Public=").append(this.isPublic).append("\n");
        out.append("Push enabled=").append(this.pushEnabled).append("\n");
        out.append("Push max size=").append(this.pushMaxSize).append(" Kb\n");
        if (this.refreshTime != null) {
            out.append("Refresh time=").append(this.refreshTime).append("\n");
            out.append("Refresh always=").append(this.refreshAlways).append("\n");
        }
        out.append("Data source=").append(this.dataSource).append("\n");
        if (this.dbSchema != null) {
            out.append("DB Schema=").append(this.dbSchema).append("\n");
        }
        out.append("DB Table=").append(this.dbTable).append("\n");
        out.append("DB SQL=").append(this.dbSQL).append("\n");
        out.append("Get all columns=").append(this.allColumnsEnabled).append("\n");
        out.append("Cache enabled=").append(this.cacheEnabled).append("\n");
        out.append("Cache max rows=").append(this.cacheMaxRows).append(" Kb\n");
        out.append("Estimate size=").append(this.estimateSize).append("\n");
        return out.toString();
    }
}

