/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.services.task.prediction.PredictionServiceRegistry;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.prediction.PredictionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalTaskEventListener
implements TaskLifeCycleEventListener {
    private RuntimeManagerRegistry registry = RuntimeManagerRegistry.get();
    private static final Logger logger = LoggerFactory.getLogger(ExternalTaskEventListener.class);
    private PredictionService predictionService = PredictionServiceRegistry.get().getService();

    public void processTaskState(Task task) {
        long workItemId = task.getTaskData().getWorkItemId();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        RuntimeManager manager = this.getManager(task);
        RuntimeEngine runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession session = runtime.getKieSession();
        if (task.getTaskData().getStatus() == Status.Completed) {
            String userId = task.getTaskData().getActualOwner().getId();
            HashMap<String, String> results = new HashMap<String, String>();
            Map taskOutcome = task.getTaskData().getTaskOutputVariables();
            if (taskOutcome != null) {
                results.putAll(taskOutcome);
            }
            results.put("ActorId", userId);
            this.predictionService.train(task, task.getTaskData().getTaskInputVariables(), results);
            session.getWorkItemManager().completeWorkItem(workItemId, results);
        } else {
            session.getWorkItemManager().abortWorkItem(workItemId);
        }
    }

    public void afterTaskActivatedEvent(Task ti) {
    }

    public void afterTaskClaimedEvent(Task ti) {
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        Task task = event.getTask();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskStartedEvent(Task ti) {
    }

    public void afterTaskStoppedEvent(Task ti) {
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        Task task = event.getTask();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        RuntimeManager manager = this.getManager(task);
        if (manager == null) {
            throw new RuntimeException("No RuntimeManager registered with identifier: " + task.getTaskData().getDeploymentId());
        }
        RuntimeEngine runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession session = runtime.getKieSession();
        if (session != null) {
            logger.debug(">> I've recieved an event for a known session (" + task.getTaskData().getProcessSessionId() + ")");
            this.processTaskState(task);
        } else {
            logger.error("EE: I've recieved an event but the session is not known by this handler ( " + task.getTaskData().getProcessSessionId() + ")");
        }
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        Task task = event.getTask();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskAddedEvent(TaskEvent event) {
    }

    public void afterTaskExitedEvent(TaskEvent event) {
    }

    public RuntimeManager getManager(Task task) {
        return this.registry.getManager(task.getTaskData().getDeploymentId());
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
    }

    public void afterTaskResumedEvent(TaskEvent event) {
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
    }

    public void afterTaskStartedEvent(TaskEvent event) {
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public void afterTaskNominatedEvent(TaskEvent event) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof ExternalTaskEventListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().getName().hashCode();
        return result;
    }
}

