/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.prediction.PredictionServiceRegistry;
import org.jbpm.services.task.utils.OnErrorAction;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.prediction.PredictionOutcome;
import org.kie.internal.task.api.prediction.PredictionService;
import org.kie.internal.task.exception.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalHTWorkItemHandler.class);
    private RuntimeManager runtimeManager;
    private PredictionService predictionService = PredictionServiceRegistry.get().getService();

    public RuntimeManager getRuntimeManager() {
        return this.runtimeManager;
    }

    public void setRuntimeManager(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block10: {
            RuntimeEngine runtime = this.runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
            KieSession ksessionById = runtime.getKieSession();
            Task task = this.createTaskBasedOnWorkItemParams(ksessionById, workItem);
            Map<String, Object> content = this.createTaskDataBasedOnWorkItemParams(ksessionById, workItem);
            try {
                PredictionOutcome outcome = this.predictionService.predict(task, content);
                if (outcome.isCertain()) {
                    logger.debug("Prediction service returned certain outcome (confidence level {}) for task {}, completing directly", (Object)outcome.getConfidenceLevel(), (Object)task);
                    manager.completeWorkItem(workItem.getId(), outcome.getData());
                } else if (outcome.isPresent()) {
                    logger.debug("Prediction service returned uncertain outcome (confidence level {}) for task {}, setting suggested data", (Object)outcome.getConfidenceLevel(), (Object)task);
                    long taskId = this.createTaskInstance((InternalTaskService)runtime.getTaskService(), task, workItem, ksessionById, content);
                    ((InternalTaskService)runtime.getTaskService()).setOutput(taskId, ADMIN_USER, (Object)outcome.getData());
                } else {
                    logger.debug("Not outcome present from prediction service, creating user task");
                    this.createTaskInstance((InternalTaskService)runtime.getTaskService(), task, workItem, ksessionById, content);
                }
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    manager.abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block10;
                StringBuilder logMsg = new StringBuilder();
                logMsg.append(new Date()).append(": Error when creating task on task server for work item id ").append(workItem.getId());
                logMsg.append(". Error reported by task server: ").append(e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
                if (e instanceof TaskException && (!(e instanceof TaskException) || ((TaskException)e).isRecoverable())) break block10;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        RuntimeEngine runtime = this.runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
        Task task = runtime.getTaskService().getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                String adminUser = ADMIN_USER;
                List businessAdmins = task.getPeopleAssignments().getBusinessAdministrators();
                for (OrganizationalEntity admin : businessAdmins) {
                    if (admin instanceof Group || admin.getId().equals(ADMIN_USER)) continue;
                    adminUser = admin.getId();
                    break;
                }
                logger.debug("Task {} is going to be exited by {} who is business admin", (Object)task.getId(), (Object)adminUser);
                runtime.getTaskService().exit(task.getId().longValue(), adminUser);
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }

    protected long createTaskInstance(InternalTaskService taskService, Task task, WorkItem workItem, KieSession session, Map<String, Object> content) {
        long taskId = taskService.addTask(task, content);
        if (this.isAutoClaim(session, workItem, task)) {
            try {
                taskService.claim(taskId, (String)workItem.getParameter("SwimlaneActorId"));
            }
            catch (PermissionDeniedException e) {
                logger.warn("User {} is not allowed to auto claim task due to permission violation", workItem.getParameter("SwimlaneActorId"));
            }
        }
        return taskId;
    }
}

