/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.fluent;

import org.drools.core.fluent.impl.BaseBatchFluent;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Executable;
import org.kie.dmn.core.fluent.ExecuteDMNCommand;
import org.kie.dmn.core.fluent.GetAllDMNContextCommand;
import org.kie.dmn.core.fluent.GetDMNDecisionResultsCommand;
import org.kie.dmn.core.fluent.GetDMNMessagesCommand;
import org.kie.dmn.core.fluent.GetDMNModelCommand;
import org.kie.dmn.core.fluent.NewDMNRuntimeCommand;
import org.kie.dmn.core.fluent.SetDMNActiveModelCommand;
import org.kie.dmn.core.fluent.SetDMNInputCommand;
import org.kie.internal.builder.fluent.CommandBasedExecutable;
import org.kie.internal.builder.fluent.DMNRuntimeFluent;
import org.kie.internal.builder.fluent.ExecutableBuilder;

public class DMNRuntimeFluentImpl
extends BaseBatchFluent<DMNRuntimeFluent, ExecutableBuilder>
implements DMNRuntimeFluent {
    private final CommandBasedExecutable ctx;

    public DMNRuntimeFluentImpl(CommandBasedExecutable ctx) {
        super((Executable)ctx);
        this.ctx = ctx;
        this.newDMNRuntime();
    }

    protected DMNRuntimeFluent newDMNRuntime() {
        this.ctx.addCommand((ExecutableCommand)new NewDMNRuntimeCommand());
        return this;
    }

    public DMNRuntimeFluent setInput(String name, Object value) {
        this.ctx.addCommand((ExecutableCommand)new SetDMNInputCommand(name, value));
        return this;
    }

    public DMNRuntimeFluent setActiveModel(String namespace, String modelName) {
        this.ctx.addCommand((ExecutableCommand)new SetDMNActiveModelCommand(namespace, modelName));
        return this;
    }

    public DMNRuntimeFluent setActiveModel(String resourcePath) {
        this.ctx.addCommand((ExecutableCommand)new SetDMNActiveModelCommand(resourcePath));
        return this;
    }

    public DMNRuntimeFluent getModel(String namespace, String modelName) {
        this.ctx.addCommand((ExecutableCommand)new GetDMNModelCommand(namespace, modelName));
        return this;
    }

    public DMNRuntimeFluent getModel(String resourcePath) {
        this.ctx.addCommand((ExecutableCommand)new GetDMNModelCommand(resourcePath));
        return this;
    }

    public DMNRuntimeFluent evaluateModel() {
        this.ctx.addCommand((ExecutableCommand)new ExecuteDMNCommand());
        return this;
    }

    public DMNRuntimeFluent getAllContext() {
        this.ctx.addCommand((ExecutableCommand)new GetAllDMNContextCommand());
        return this;
    }

    public DMNRuntimeFluent getDecisionResults() {
        this.ctx.addCommand((ExecutableCommand)new GetDMNDecisionResultsCommand());
        return this;
    }

    public DMNRuntimeFluent getMessages() {
        this.ctx.addCommand((ExecutableCommand)new GetDMNMessagesCommand());
        return this;
    }
}

