/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.admin.listener.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.ProcessInstanceIdCommand;

@XmlRootElement(name="get-current-tx-tasks-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetCurrentTxTasksCommand
extends TaskCommand<List<TaskSummary>>
implements ProcessInstanceIdCommand {
    private static final long serialVersionUID = 6474368266134150938L;
    @XmlElement(required=true)
    @XmlSchemaType(name="long")
    private Long processInstanceId;

    public GetCurrentTxTasksCommand() {
    }

    public GetCurrentTxTasksCommand(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public List<TaskSummary> execute(Context context) {
        ArrayList<TaskSummary> tasks = new ArrayList<TaskSummary>();
        Set tasksToRemove = (Set)context.get("local:current-tasks");
        if (tasksToRemove != null) {
            for (TaskSummary task : tasksToRemove) {
                if (!Objects.equals(task.getProcessInstanceId(), this.processInstanceId)) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }
}

