/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class KnowledgeSessionCleanup
implements MethodRule {
    protected static ThreadLocal<Set<StatefulKnowledgeSession>> knowledgeSessionSetLocal = new ThreadLocal();

    public static void addKnowledgeSessionForCleanup(StatefulKnowledgeSession ksession) {
        knowledgeSessionSetLocal.get().add(ksession);
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    Set<StatefulKnowledgeSession> ksessionSet = knowledgeSessionSetLocal.get();
                    if (!ksessionSet.isEmpty()) {
                        Iterator<StatefulKnowledgeSession> iter = ksessionSet.iterator();
                        while (iter.hasNext()) {
                            StatefulKnowledgeSession ksession = iter.next();
                            if (ksession != null) {
                                try {
                                    ksession.dispose();
                                }
                                catch (Throwable throwable) {}
                            }
                            iter.remove();
                        }
                    }
                }
            }
        };
    }

    static {
        knowledgeSessionSetLocal.set(new HashSet());
    }
}

