/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkItemResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkItemNodeInstance.class);
    private static boolean variableStrictEnabled = Boolean.parseBoolean(System.getProperty("org.jbpm.variable.strict", "false"));
    private static List<String> defaultOutputVariables = Arrays.asList("ActorId");
    private Map<String, ContextInstance> contextInstances = new HashMap<String, ContextInstance>();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private long workItemId = -1L;
    private transient WorkItem workItem;

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public WorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId >= 0L) {
            this.workItem = ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void internalSetWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public void internalSetWorkItem(WorkItem workItem) {
        this.workItem = workItem;
    }

    @Override
    public boolean isInversionOfControl() {
        return false;
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
            return;
        }
        WorkItemNode workItemNode = this.getWorkItemNode();
        this.createWorkItem(workItemNode);
        if (workItemNode.isWaitForCompletion()) {
            this.addWorkItemListener();
        }
        String deploymentId = (String)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("deploymentId");
        this.workItem.setDeploymentId(deploymentId);
        this.workItem.setNodeInstanceId(this.getId());
        this.workItem.setNodeId(this.getNodeId());
        if (this.isInversionOfControl()) {
            this.getProcessInstance().getKnowledgeRuntime().update(this.getProcessInstance().getKnowledgeRuntime().getFactHandle((Object)this), (Object)this);
        } else {
            try {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem(this.workItem);
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
            catch (Exception e) {
                String exceptionName = e.getClass().getName();
                ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
                if (exceptionScopeInstance == null) {
                    throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
                }
                this.workItemId = this.workItem.getId();
                exceptionScopeInstance.handleException(exceptionName, e);
            }
        }
        if (!workItemNode.isWaitForCompletion()) {
            this.triggerCompleted();
        }
        this.workItemId = this.workItem.getId();
    }

    protected WorkItem createWorkItem(WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        this.workItem = new WorkItemImpl();
        this.workItem.setName(work.getName());
        this.workItem.setProcessInstanceId(this.getProcessInstance().getId());
        this.workItem.setParameters(new HashMap<String, Object>(work.getParameters()));
        if (this.dynamicParameters != null) {
            this.workItem.getParameters().putAll(this.dynamicParameters);
        }
        for (DataAssociation association : workItemNode.getInAssociations()) {
            if (association.getTransformation() != null) {
                Object parameterValue;
                Transformation transformation = association.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer == null || (parameterValue = transformer.transform(transformation.getCompiledExpression(), this.getSourceParameters(association))) == null) continue;
                this.workItem.setParameter(association.getTarget(), parameterValue);
                continue;
            }
            if (association.getAssignments() == null || association.getAssignments().isEmpty()) {
                Object parameterValue = null;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getSources().get(0));
                if (variableScopeInstance != null) {
                    parameterValue = variableScopeInstance.getVariable(association.getSources().get(0));
                } else {
                    try {
                        parameterValue = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    }
                    catch (Throwable t) {
                        logger.error("Could not find variable scope for variable {}", (Object)association.getSources().get(0));
                        logger.error("when trying to execute Work Item {}", (Object)work.getName());
                        logger.error("Continuing without setting parameter.");
                    }
                }
                if (parameterValue == null) continue;
                this.workItem.setParameter(association.getTarget(), parameterValue);
                continue;
            }
            Iterator<Assignment> it = association.getAssignments().iterator();
            while (it.hasNext()) {
                this.handleAssignment(it.next());
            }
        }
        for (Map.Entry entry : this.workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVELSafeHelper.getEvaluator().eval(paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    logger.error("Could not find variable scope for variable {}", (Object)paramName);
                    logger.error("when trying to replace variable in string for Work Item {}", (Object)work.getName());
                    logger.error("Continuing without setting parameter.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            this.workItem.setParameter((String)entry.getKey(), (Object)s);
        }
        return this.workItem;
    }

    private void handleAssignment(Assignment assignment) {
        AssignmentAction action = (AssignmentAction)assignment.getMetaData("Action");
        try {
            org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            context.setNodeInstance((NodeInstance)this);
            action.execute(this.getWorkItem(), (ProcessContext)context);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to execute Assignment", e);
        }
    }

    public void triggerCompleted(WorkItem workItem) {
        VariableScopeInstance variableScopeInstance;
        this.workItem = workItem;
        WorkItemNode workItemNode = this.getWorkItemNode();
        if (workItemNode != null && workItem.getState() == 2) {
            this.validateWorkItemResultVariable(this.getProcessInstance().getProcessName(), workItemNode.getOutAssociations(), workItem);
            for (DataAssociation association : this.getWorkItemNode().getOutAssociations()) {
                if (association.getTransformation() != null) {
                    Transformation transformation = association.getTransformation();
                    DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                    if (transformer == null) continue;
                    Object parameterValue = transformer.transform(transformation.getCompiledExpression(), workItem.getResults());
                    VariableScopeInstance variableScopeInstance2 = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                    if (variableScopeInstance2 != null && parameterValue != null) {
                        variableScopeInstance2.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), parameterValue);
                        variableScopeInstance2.setVariable(association.getTarget(), parameterValue);
                    } else {
                        logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                        logger.warn("when trying to complete Work Item {}", (Object)workItem.getName());
                        logger.warn("Continuing without setting variable.");
                    }
                    if (parameterValue == null) continue;
                    workItem.setParameter(association.getTarget(), parameterValue);
                    continue;
                }
                if (association.getAssignments() == null || association.getAssignments().isEmpty()) {
                    variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                    if (variableScopeInstance != null) {
                        Variable varDef;
                        DataType dataType;
                        Object value = workItem.getResult(association.getSources().get(0));
                        if (value == null) {
                            try {
                                value = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new WorkItemResolverFactory((org.kie.api.runtime.process.WorkItem)workItem));
                            }
                            catch (Throwable parameterValue) {
                                // empty catch block
                            }
                        }
                        if (!(dataType = (varDef = variableScopeInstance.getVariableScope().findVariable(association.getTarget())).getType()).getStringType().endsWith("java.lang.Object") && !dataType.getStringType().endsWith("Object") && value instanceof String) {
                            value = dataType.readValue((String)value);
                        } else {
                            variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), value);
                        }
                        variableScopeInstance.setVariable(association.getTarget(), value);
                        continue;
                    }
                    logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                    logger.warn("when trying to complete Work Item {}", (Object)workItem.getName());
                    logger.warn("Continuing without setting variable.");
                    continue;
                }
                try {
                    Iterator<Assignment> it = association.getAssignments().iterator();
                    while (it.hasNext()) {
                        this.handleAssignment(it.next());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", workItem.getName());
            Map results = workItem.getResults();
            if (results != null && !results.isEmpty()) {
                VariableScope variableScope = (VariableScope)((ContextContainer)this.getProcessInstance().getProcess()).getDefaultContext("VariableScope");
                variableScopeInstance = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
                for (Map.Entry result : results.entrySet()) {
                    if (variableScope.findVariable((String)result.getKey()) == null) continue;
                    variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), (String)result.getKey(), result.getValue());
                    variableScopeInstance.setVariable((String)result.getKey(), result.getValue());
                }
            }
        }
        if (this.isInversionOfControl()) {
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            kruntime.update(kruntime.getFactHandle((Object)this), (Object)this);
        } else {
            this.triggerCompleted();
        }
    }

    @Override
    public void cancel() {
        WorkItem workItem = this.getWorkItem();
        if (workItem != null && workItem.getState() != 2 && workItem.getState() != 3) {
            try {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAbortWorkItem(this.workItemId);
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
        }
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
    }

    private void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", this, false);
        this.getProcessInstance().addEventListener("workItemAborted", this, false);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("workItemCompleted", this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", this, false);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((WorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((WorkItem)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"workItemCompleted"};
    }

    public void workItemAborted(WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public void workItemCompleted(WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            String nodeName = "[Dynamic]";
            WorkItem workItem = this.getWorkItem();
            if (workItem != null) {
                nodeName = nodeName + " " + workItem.getParameter("TaskName");
            }
            return nodeName;
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getWorkItemNode();
    }

    protected Map<String, Object> getSourceParameters(DataAssociation association) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String sourceParam : association.getSources()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", sourceParam);
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(sourceParam);
            } else {
                try {
                    parameterValue = MVELSafeHelper.getEvaluator().eval(sourceParam, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.warn("Could not find variable scope for variable {}", (Object)sourceParam);
                }
            }
            if (parameterValue == null) continue;
            parameters.put(association.getTarget(), parameterValue);
        }
        return parameters;
    }

    public void validateWorkItemResultVariable(String processName, List<DataAssociation> outputs, WorkItem workItem) {
        if (!variableStrictEnabled || workItem.getResults().isEmpty()) {
            return;
        }
        ArrayList<String> outputNames = new ArrayList<String>();
        for (DataAssociation association : outputs) {
            if (association.getSources() != null) {
                outputNames.add(association.getSources().get(0));
            }
            if (association.getAssignments() == null) continue;
            Iterator<Assignment> it = association.getAssignments().iterator();
            while (it.hasNext()) {
                outputNames.add(it.next().getFrom());
            }
        }
        for (String outputName : workItem.getResults().keySet()) {
            if (outputNames.contains(outputName) || defaultOutputVariables.contains(outputName)) continue;
            throw new IllegalArgumentException("Data output '" + outputName + "' is not defined in process '" + processName + "' for task '" + workItem.getParameter("NodeName") + "'");
        }
    }
}

