/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidParameter;

public class WidInfo {
    private String widfile;
    private String name;
    private String displayName;
    private String category;
    private String icon;
    private String description;
    private String defaultHandler;
    private Map<String, InternalWidParamsAndResults> parameters;
    private Map<String, InternalWidParamsAndResults> results;
    private Map<String, InternalWidMavenDependencies> mavenDepends;

    public WidInfo(Wid wid) {
        this.widfile = wid.widfile();
        this.name = wid.name();
        this.displayName = wid.displayName();
        this.category = wid.category();
        this.icon = wid.icon();
        this.description = wid.description();
        this.defaultHandler = wid.defaultHandler();
        this.parameters = new HashMap<String, InternalWidParamsAndResults>();
        if (wid.parameters().length > 0) {
            for (WidParameter widParameter : wid.parameters()) {
                this.parameters.put(widParameter.name(), new InternalWidParamsAndResults(widParameter.name(), widParameter.type()));
            }
        }
        this.results = new HashMap<String, InternalWidParamsAndResults>();
        if (wid.results().length > 0) {
            for (Annotation annotation : wid.results()) {
                this.results.put(annotation.name(), new InternalWidParamsAndResults(annotation.name(), annotation.type()));
            }
        }
        this.mavenDepends = new HashMap<String, InternalWidMavenDependencies>();
        if (wid.mavenDepends().length > 0) {
            for (Annotation annotation : wid.mavenDepends()) {
                this.mavenDepends.put(annotation.group() + "." + annotation.artifact() + "." + annotation.version(), new InternalWidMavenDependencies(annotation.group(), annotation.artifact(), annotation.version()));
            }
        }
    }

    public String getWidfile() {
        return this.widfile;
    }

    public void setWidfile(String widfile) {
        this.widfile = widfile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(String defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public Map<String, InternalWidParamsAndResults> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, InternalWidParamsAndResults> parameters) {
        this.parameters = parameters;
    }

    public Map<String, InternalWidParamsAndResults> getResults() {
        return this.results;
    }

    public void setResults(Map<String, InternalWidParamsAndResults> results) {
        this.results = results;
    }

    public Map<String, InternalWidMavenDependencies> getMavenDepends() {
        return this.mavenDepends;
    }

    public void setMavenDepends(Map<String, InternalWidMavenDependencies> mavenDepends) {
        this.mavenDepends = mavenDepends;
    }

    private class InternalWidMavenDependencies {
        private String group;
        private String artifact;
        private String version;

        public InternalWidMavenDependencies(String group, String artifact, String version) {
            this.group = group;
            this.artifact = artifact;
            this.version = version;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    private class InternalWidParamsAndResults {
        private String name;
        private String type;

        public InternalWidParamsAndResults(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

