/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.DMNScope;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class DMNCompilerContext {
    private final DMNFEELHelper feelHelper;
    private Stack<DMNScope> stack = new Stack();
    private Function<String, Reader> relativeResolver;

    public DMNCompilerContext(DMNFEELHelper feelHelper) {
        this.feelHelper = feelHelper;
        this.stack.push(new DMNScope());
    }

    public void enterFrame() {
        this.stack.push(new DMNScope(this.stack.peek()));
    }

    public void exitFrame() {
        this.stack.pop();
    }

    public DMNType resolve(String name) {
        return this.stack.peek().resolve(name);
    }

    public void setVariable(String name, DMNType type) {
        this.stack.peek().setVariable(name, type);
    }

    public Map<String, DMNType> getVariables() {
        HashMap<String, DMNType> variables = new HashMap<String, DMNType>();
        for (DMNScope scope : this.stack) {
            variables.putAll(scope.getVariables());
        }
        return variables;
    }

    public CompilerContext toCompilerContext() {
        CompilerContext compilerContext = this.feelHelper.newCompilerContext();
        compilerContext.getListeners().clear();
        for (Map.Entry<String, DMNType> entry : this.getVariables().entrySet()) {
            compilerContext.addInputVariableType(entry.getKey(), DMNCompilerContext.dmnToFeelType((BaseDMNTypeImpl)entry.getValue()));
        }
        return compilerContext;
    }

    private static Type dmnToFeelType(BaseDMNTypeImpl v) {
        if (v.isCollection()) {
            return BuiltInType.LIST;
        }
        return v.getFeelType();
    }

    public DMNFEELHelper getFeelHelper() {
        return this.feelHelper;
    }

    public void setRelativeResolver(Function<String, Reader> relativeResolver) {
        this.relativeResolver = relativeResolver;
    }

    public Function<String, Reader> getRelativeResolver() {
        return this.relativeResolver;
    }
}

