/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.kie.api.definition.process.Process;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.InternalRuntimeManager;

public abstract class AbstractProcessInstanceFactory
implements ProcessInstanceFactory {
    @Override
    public ProcessInstance createProcessInstance(Process process, CorrelationKey correlationKey, InternalKnowledgeRuntime kruntime, Map<String, Object> parameters) {
        InternalRuntimeManager manager;
        ProcessInstance processInstance = this.createProcessInstance();
        processInstance.setKnowledgeRuntime(kruntime);
        processInstance.setProcess(process);
        if (correlationKey != null) {
            processInstance.getMetaData().put("CorrelationKey", correlationKey);
        }
        if ((manager = (InternalRuntimeManager)kruntime.getEnvironment().get("RuntimeManager")) != null) {
            processInstance.setDeploymentId(manager.getIdentifier());
        }
        ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessInstanceManager().addProcessInstance(processInstance, correlationKey);
        if (parameters != null && parameters.containsKey("ParentInstanceId")) {
            processInstance.getMetaData().put("ParentProcessInstanceId", (Long)parameters.get("ParentInstanceId"));
        }
        VariableScope variableScope = (VariableScope)((ContextContainer)process).getDefaultContext("VariableScope");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        if (parameters != null) {
            if (variableScope != null) {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    variableScope.validateVariable(process.getName(), entry.getKey(), entry.getValue());
                    variableScopeInstance.setVariable(entry.getKey(), entry.getValue());
                }
            } else {
                throw new IllegalArgumentException("This process does not support parameters!");
            }
        }
        return processInstance;
    }

    public abstract ProcessInstance createProcessInstance();
}

