/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DecisionServiceNodeImpl;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDecisionServiceEvaluator
implements DMNExpressionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(DMNDecisionServiceEvaluator.class);
    private DecisionServiceNode dsNode;
    private boolean transferResult;
    private boolean coerceSingletonResult;

    public DMNDecisionServiceEvaluator(DecisionServiceNode dsNode, boolean transferResult, boolean coerceSingletonResult) {
        this.dsNode = dsNode;
        this.transferResult = transferResult;
        this.coerceSingletonResult = coerceSingletonResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult r) {
        void var11_19;
        Object object;
        DMNResultImpl result = (DMNResultImpl)r;
        DMNRuntimeEventManagerUtils.fireBeforeEvaluateDecisionService(eventManager, this.dsNode, result);
        DMNRuntime dmnRuntime = eventManager.getRuntime();
        DMNModel dmnModel = dmnRuntime.getModel(this.dsNode.getModelNamespace(), this.dsNode.getModelName());
        List<String> decisionIDs = this.dsNode.getDecisionService().getOutputDecision().stream().map(er -> DMNCompilerImpl.getId(er)).collect(Collectors.toList());
        DMNResult evaluateById = dmnRuntime.evaluateById(dmnModel, result.getContext().clone(), decisionIDs.toArray(new String[0]));
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ArrayList<DMNDecisionResult> decisionResults = new ArrayList<DMNDecisionResult>();
        for (String string : decisionIDs) {
            DMNDecisionResult decisionResultById = evaluateById.getDecisionResultById(string);
            String decisionName = dmnModel.getDecisionById(string).getName();
            ctx.put(decisionName, decisionResultById.getResult());
            decisionResults.add(decisionResultById);
        }
        boolean errors = false;
        for (DMNMessage m : evaluateById.getMessages()) {
            result.addMessage(m);
            if (m.getSeverity() != DMNMessage.Severity.ERROR) continue;
            errors = true;
        }
        if (((DMNRuntimeImpl)eventManager.getRuntime()).performRuntimeTypeCheck(result.getModel()) && (object = DMNRuntimeImpl.coerceUsingType(ctx, this.dsNode.getResultType(), (rx, tx) -> MsgUtil.reportMessage(LOG, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)this.dsNode.getDecisionService(), result, null, null, Msg.ERROR_EVAL_NODE_RESULT_WRONG_TYPE, this.dsNode.getDecisionService().getName() != null ? this.dsNode.getDecisionService().getName() : this.dsNode.getDecisionService().getId(), tx, MsgUtil.clipString(rx.toString(), 50)))) == null) {
            ctx.clear();
            decisionResults.clear();
        }
        for (DMNDecisionResult dr : decisionResults) {
            result.getContext().set(dr.getDecisionName(), dr.getResult());
            if (!this.transferResult) continue;
            result.addDecisionResult(dr);
        }
        DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionService(eventManager, this.dsNode, result);
        HashMap<String, Object> hashMap = ctx;
        if (decisionIDs.size() == 1 && this.coerceSingletonResult) {
            Object v = ctx.values().iterator().next();
        }
        EvaluatorResult.ResultType resultType = EvaluatorResult.ResultType.SUCCESS;
        if (errors) {
            resultType = EvaluatorResult.ResultType.FAILURE;
            MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DecisionServiceNodeImpl)this.dsNode).getSource(), result, null, null, Msg.ERRORS_EVAL_DS_NODE, this.dsNode.getName());
        }
        return new EvaluatorResultImpl(var11_19, resultType);
    }
}

