/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.support_vector_machine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"description", "gamma", "extensions"})
public class RadialBasisKernel
extends Kernel
implements HasExtensions<RadialBasisKernel> {
    @XmlAttribute(name="description")
    @JsonProperty(value="description")
    private String description;
    @XmlAttribute(name="gamma")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="gamma")
    private Number gamma;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 67305489L;

    public String getDescription() {
        return this.description;
    }

    public RadialBasisKernel setDescription(@Property(value="description") String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (this.gamma == null) {
            return DEFAULT_GAMMA;
        }
        return this.gamma;
    }

    public RadialBasisKernel setGamma(@Property(value="gamma") Number gamma) {
        this.gamma = gamma;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RadialBasisKernel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

