/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jbpm.services.task.assignment.impl.AssignmentImpl;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskContext;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.assignment.Assignment;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotentialOwnerBusynessAssignmentStrategy
implements AssignmentStrategy {
    private static final Logger logger = LoggerFactory.getLogger(PotentialOwnerBusynessAssignmentStrategy.class);
    public static final String IDENTIFIER = "PotentialOwnerBusyness";
    private static final String DEFAULT_QUERY = "select new org.jbpm.services.task.assignment.impl.AssignmentImpl(t.taskData.actualOwner.id, count(t)) from TaskImpl t where t.taskData.actualOwner.id in (:owners) and t.taskData.status in ('Reserved', 'InProgress', 'Suspended') group by t.taskData.actualOwner order by count(t) asc, t.taskData.actualOwner.id asc";

    public Assignment apply(Task task, TaskContext context, String excludedUser) {
        if (task.getPeopleAssignments().getPotentialOwners().isEmpty()) {
            logger.debug("No potential owners in the task {} can't auto assign", (Object)task);
            return null;
        }
        ArrayList potentialOwners = new ArrayList(task.getPeopleAssignments().getPotentialOwners());
        TreeSet<String> resolvedUsers = new TreeSet<String>(Collections.reverseOrder());
        List excludedOwners = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        potentialOwners.stream().filter(po -> po instanceof User && !excludedOwners.contains(po)).forEach(po -> resolvedUsers.add(po.getId()));
        UserInfo userInfo = (UserInfo)((org.jbpm.services.task.commands.TaskContext)context).get("org.kie.api.task.UserInfo");
        if (userInfo != null) {
            logger.debug("Groups going to be resolved by {}", (Object)userInfo);
            potentialOwners.stream().filter(po -> po instanceof Group && !excludedOwners.contains(po)).forEach(po -> {
                Iterator usersOfGroup = userInfo.getMembersForGroup((Group)po);
                if (usersOfGroup != null) {
                    while (usersOfGroup.hasNext()) {
                        OrganizationalEntity entity = (OrganizationalEntity)usersOfGroup.next();
                        if (excludedOwners.contains(entity)) continue;
                        resolvedUsers.add(entity.getId());
                    }
                }
            });
        }
        logger.debug("Resolved users eligible for task {} assignments are {}", (Object)task, resolvedUsers);
        if (excludedUser != null) {
            logger.debug("Removing excluded user {} from the list of eligible users", (Object)excludedUser);
            resolvedUsers.remove(excludedUser);
        }
        TaskPersistenceContext persistenceContext = ((org.jbpm.services.task.commands.TaskContext)context).getPersistenceContext();
        HashMap<String, TreeSet<String>> params = new HashMap<String, TreeSet<String>>();
        params.put("owners", resolvedUsers);
        logger.debug("DB query to be used for finding assignments :: '{}'", (Object)this.getQuery());
        List assignments = (List)persistenceContext.queryStringWithParametersInTransaction(this.getQuery(), params, ClassUtil.castClass(List.class));
        if (assignments.size() < resolvedUsers.size()) {
            logger.debug("Not all eligible users found in db, adding missing bits (eligible {}, found in db {})", resolvedUsers, (Object)assignments);
            resolvedUsers.forEach(user -> {
                AssignmentImpl assignment = new AssignmentImpl((String)user);
                if (!assignments.contains((Object)assignment)) {
                    assignments.add(0, assignment);
                }
            });
        }
        if (assignments.isEmpty()) {
            logger.debug("No assignments found for task {}", (Object)task);
            return null;
        }
        logger.debug("Following assignments {} were found for task {}", (Object)assignments, (Object)task);
        Assignment selected = (Assignment)assignments.get(0);
        logger.debug("Retruning first of found assignments {}", (Object)selected);
        return new Assignment(selected.getUser());
    }

    protected String getQuery() {
        return DEFAULT_QUERY;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String toString() {
        return "AssignmentStrategy:: PotentialOwnerBusyness";
    }
}

