/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.AfterGeneratingSourcesListener;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DMNContextEvaluator;
import org.kie.dmn.core.ast.DMNDTExpressionEvaluator;
import org.kie.dmn.core.ast.DMNFunctionDefinitionEvaluator;
import org.kie.dmn.core.ast.DMNInvocationEvaluator;
import org.kie.dmn.core.ast.DMNListEvaluator;
import org.kie.dmn.core.ast.DMNLiteralExpressionEvaluator;
import org.kie.dmn.core.ast.DMNRelationEvaluator;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.execmodelbased.DMNRuleClassFile;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNClassLoaderCompiler;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNMavenSourceCompiler;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.pmml.AbstractPMMLInvocationEvaluator;
import org.kie.dmn.core.pmml.DMNImportPMMLInfo;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.impl.RootExecutionFrame;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.model.api.Binding;
import org.kie.dmn.model.api.BusinessKnowledgeModel;
import org.kie.dmn.model.api.Context;
import org.kie.dmn.model.api.ContextEntry;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionRule;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.FunctionDefinition;
import org.kie.dmn.model.api.FunctionKind;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.Invocation;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.NamedElement;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.Relation;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.dmn.model.v1_1.TLiteralExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNEvaluatorCompiler {
    private static final Logger logger = LoggerFactory.getLogger(DMNEvaluatorCompiler.class);
    protected final DMNCompilerImpl compiler;

    protected DMNEvaluatorCompiler(DMNCompilerImpl compiler) {
        this.compiler = compiler;
    }

    public static DMNEvaluatorCompiler dmnEvaluatorCompilerFactory(DMNCompilerImpl dmnCompiler, DMNCompilerConfigurationImpl dmnCompilerConfig) {
        DMNRuleClassFile dmnRuleClassFile = new DMNRuleClassFile(dmnCompilerConfig.getRootClassLoader());
        if (dmnRuleClassFile.hasCompiledClasses()) {
            logger.debug("Using ExecModelDMNClassLoaderCompiler.");
            return new ExecModelDMNClassLoaderCompiler(dmnCompiler, dmnRuleClassFile);
        }
        if (dmnCompilerConfig.isDeferredCompilation()) {
            ExecModelDMNMavenSourceCompiler evaluatorCompiler = new ExecModelDMNMavenSourceCompiler(dmnCompiler);
            for (AfterGeneratingSourcesListener l : dmnCompilerConfig.getAfterGeneratingSourcesListeners()) {
                evaluatorCompiler.register(l);
            }
            return evaluatorCompiler;
        }
        if (dmnCompilerConfig.isUseExecModelCompiler()) {
            logger.debug("Using ExecModelDMNEvaluatorCompiler.");
            return new ExecModelDMNEvaluatorCompiler(dmnCompiler);
        }
        logger.debug("default DMNEvaluatorCompiler.");
        return new DMNEvaluatorCompiler(dmnCompiler);
    }

    public DMNExpressionEvaluator compileExpression(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Expression expression) {
        if (expression == null) {
            if (node instanceof DecisionNode) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.MISSING_EXPRESSION_FOR_DECISION, node.getIdentifierString());
            } else if (node instanceof BusinessKnowledgeModelNode) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.MISSING_EXPRESSION_FOR_BKM, node.getIdentifierString());
            } else {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.MISSING_EXPRESSION_FOR_NODE, node.getIdentifierString());
            }
        } else {
            if (expression instanceof LiteralExpression) {
                return this.compileLiteralExpression(ctx, model, node, exprName, (LiteralExpression)expression);
            }
            if (expression instanceof DecisionTable) {
                return this.compileDecisionTable(ctx, model, node, exprName, (DecisionTable)expression);
            }
            if (expression instanceof FunctionDefinition) {
                return this.compileFunctionDefinition(ctx, model, node, exprName, (FunctionDefinition)expression);
            }
            if (expression instanceof Context) {
                return this.compileContext(ctx, model, node, exprName, (Context)expression);
            }
            if (expression instanceof org.kie.dmn.model.api.List) {
                return this.compileList(ctx, model, node, exprName, (org.kie.dmn.model.api.List)expression);
            }
            if (expression instanceof Relation) {
                return this.compileRelation(ctx, model, node, exprName, (Relation)expression);
            }
            if (expression instanceof Invocation) {
                return this.compileInvocation(ctx, model, node, (Invocation)expression);
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.EXPR_TYPE_NOT_SUPPORTED_IN_NODE, expression.getClass().getSimpleName(), node.getIdentifierString());
        }
        return null;
    }

    protected ClassLoader getRootClassLoader() {
        return this.getDmnCompilerConfig().getRootClassLoader();
    }

    protected DMNCompilerConfigurationImpl getDmnCompilerConfig() {
        return (DMNCompilerConfigurationImpl)this.compiler.getDmnCompilerConfig();
    }

    private DMNExpressionEvaluator compileInvocation(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, Invocation expression) {
        boolean findInContext;
        Invocation invocation = expression;
        if (invocation.getExpression() == null || ((LiteralExpression)invocation.getExpression()).getText().isEmpty()) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)invocation, model, null, null, Msg.MISSING_EXPRESSION_FOR_INVOCATION, node.getIdentifierString());
            return null;
        }
        String functionName = ((LiteralExpression)invocation.getExpression()).getText();
        String[] fnameParts = functionName.split("\\.");
        Optional<Object> findAsDep = Optional.empty();
        if (fnameParts.length == 2) {
            QName importAlias = model.getImportNamespaceAndNameforAlias(fnameParts[0]);
            findAsDep = node.getDependencies().values().stream().filter(d -> d.getModelNamespace().equals(importAlias.getNamespaceURI()) && d.getName().equals(fnameParts[1])).findAny();
        } else {
            findAsDep = node.getDependencies().values().stream().filter(d -> d.getName().equals(functionName)).findAny();
        }
        boolean findAsBuiltin = RootExecutionFrame.INSTANCE.getValue(functionName) != null;
        boolean findAsCustomFunction = ctx.getFeelHelper().newCompilerContext().getFEELFunctions().stream().anyMatch(f -> f.getName().equals(functionName));
        boolean bl = findInContext = ctx.getVariables().get(functionName) != null;
        if (!(findAsDep.isPresent() || findAsBuiltin || findAsCustomFunction || findInContext)) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)invocation, model, null, null, Msg.EXPRESSION_FOR_INVOCATION_NOT_RESOLVED, functionName, node.getIdentifierString(), node.getDependencies().values().stream().map(DMNNode::getName).collect(Collectors.toList()));
        }
        DMNInvocationEvaluator invEval = new DMNInvocationEvaluator(node.getName(), (DMNElement)node.getSource(), functionName, invocation, null, ctx.getFeelHelper().newFEELInstance());
        for (Binding binding : invocation.getBinding()) {
            if (binding.getParameter() == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)binding, model, null, null, Msg.MISSING_PARAMETER_FOR_INVOCATION, node.getIdentifierString());
                return null;
            }
            if (binding.getExpression() == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)binding, model, null, null, Msg.MISSING_EXPRESSION_FOR_PARAM_OF_INVOCATION, binding.getParameter().getIdentifierString(), node.getIdentifierString());
                return null;
            }
            invEval.addParameter(binding.getParameter().getName(), this.compiler.resolveTypeRef(model, (NamedElement)binding.getParameter(), (DMNModelInstrumentedBase)binding.getParameter(), binding.getParameter().getTypeRef()), this.compileExpression(ctx, model, node, binding.getParameter().getName(), binding.getExpression()));
        }
        return invEval;
    }

    private DMNExpressionEvaluator compileRelation(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String relationName, Relation expression) {
        Relation relationDef = expression;
        DMNRelationEvaluator relationEval = new DMNRelationEvaluator(node.getName(), (DMNElement)node.getSource(), relationDef);
        for (InformationItem col : relationDef.getColumn()) {
            DMNCompilerHelper.checkVariableName(model, (NamedElement)col, col.getName());
            relationEval.addColumn(col.getName());
        }
        for (org.kie.dmn.model.api.List row : relationDef.getRow()) {
            ArrayList<DMNExpressionEvaluator> values = new ArrayList<DMNExpressionEvaluator>();
            for (Expression expr : row.getExpression()) {
                LiteralExpression literalExpression;
                if (expr instanceof LiteralExpression && ((literalExpression = (LiteralExpression)expr).getText() == null || literalExpression.getText().isEmpty())) {
                    TLiteralExpression nullProxy = literalExpression instanceof TLiteralExpression ? new TLiteralExpression() : new org.kie.dmn.model.v1_2.TLiteralExpression();
                    nullProxy.setText("null");
                    nullProxy.setImportedValues(literalExpression.getImportedValues());
                    nullProxy.setExpressionLanguage(literalExpression.getExpressionLanguage());
                    nullProxy.setTypeRef(literalExpression.getTypeRef());
                    nullProxy.setId(literalExpression.getId());
                    nullProxy.setLabel(literalExpression.getLabel());
                    nullProxy.setDescription(literalExpression.getDescription());
                    nullProxy.setExtensionElements(literalExpression.getExtensionElements());
                    nullProxy.setParent(literalExpression.getParent());
                    nullProxy.getNsContext().putAll(literalExpression.getNsContext());
                    nullProxy.setAdditionalAttributes(literalExpression.getAdditionalAttributes());
                    nullProxy.setLocation(literalExpression.getLocation());
                    expr = nullProxy;
                }
                values.add(this.compileExpression(ctx, model, node, relationName, expr));
            }
            relationEval.addRow(values);
        }
        return relationEval;
    }

    private DMNExpressionEvaluator compileList(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String listName, org.kie.dmn.model.api.List expression) {
        org.kie.dmn.model.api.List listDef = expression;
        DMNListEvaluator listEval = new DMNListEvaluator(node.getName(), (DMNElement)node.getSource(), listDef);
        for (Expression expr : listDef.getExpression()) {
            listEval.addElement(this.compileExpression(ctx, model, node, listName, expr));
        }
        return listEval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileContext(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String contextName, Context expression) {
        Context ctxDef = expression;
        DMNContextEvaluator ctxEval = new DMNContextEvaluator(node.getName(), ctxDef);
        ctx.enterFrame();
        try {
            for (ContextEntry ce : ctxDef.getContextEntry()) {
                if (ce.getVariable() != null) {
                    String entryName = ce.getVariable().getName();
                    DMNCompilerHelper.checkVariableName(model, node.getSource(), entryName);
                    DMNType entryType = this.compiler.resolveTypeRef(model, (NamedElement)ce.getVariable(), (DMNModelInstrumentedBase)ce.getVariable(), ce.getVariable().getTypeRef());
                    ctx.setVariable(entryName, entryType);
                    DMNExpressionEvaluator evaluator = this.compileExpression(ctx, model, node, entryName, ce.getExpression());
                    ctxEval.addEntry(entryName, entryType, evaluator, ce);
                    continue;
                }
                DMNType type = null;
                if (ctxDef.getParent() instanceof ContextEntry && ((ContextEntry)ctxDef.getParent()).getVariable() != null) {
                    ContextEntry parentEntry = (ContextEntry)ctxDef.getParent();
                    type = this.compiler.resolveTypeRef(model, (NamedElement)parentEntry.getVariable(), (DMNModelInstrumentedBase)parentEntry.getVariable(), parentEntry.getVariable().getTypeRef());
                } else if (node instanceof BusinessKnowledgeModelNode) {
                    type = ((BusinessKnowledgeModelNode)node).getResultType();
                } else if (node instanceof DecisionNode) {
                    type = ((DecisionNode)node).getResultType();
                }
                ctxEval.addEntry("__RESULT__", type, this.compileExpression(ctx, model, node, contextName, ce.getExpression()), ce);
            }
        }
        finally {
            ctx.exitFrame();
        }
        return ctxEval;
    }

    private DMNExpressionEvaluator compileFunctionDefinition(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String functionName, FunctionDefinition funcDef) {
        FunctionKind kind = funcDef.getKind();
        if (kind == null) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_INVALID_KIND, kind, node.getIdentifierString());
            return new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
        }
        if (kind.equals((Object)FunctionKind.FEEL)) {
            return this.compileFunctionDefinitionFEEL(ctx, model, node, functionName, funcDef);
        }
        if (kind.equals((Object)FunctionKind.JAVA)) {
            return this.compileFunctionDefinitionJAVA(ctx, model, node, functionName, funcDef);
        }
        if (kind.equals((Object)FunctionKind.PMML)) {
            return this.compileFunctionDefinitionPMML(ctx, model, node, functionName, funcDef);
        }
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_INVALID_KIND, kind, node.getIdentifierString());
        return new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileFunctionDefinitionFEEL(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String functionName, FunctionDefinition funcDef) {
        ctx.enterFrame();
        try {
            DMNFunctionDefinitionEvaluator func = new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
            for (InformationItem p : funcDef.getFormalParameter()) {
                DMNCompilerHelper.checkVariableName(model, (NamedElement)p, p.getName());
                DMNType dmnType = this.compiler.resolveTypeRef(model, (NamedElement)p, (DMNModelInstrumentedBase)p, p.getTypeRef());
                func.addParameter(p.getName(), dmnType);
                ctx.setVariable(p.getName(), dmnType);
            }
            DMNExpressionEvaluator eval = this.compileExpression(ctx, model, node, functionName, funcDef.getExpression());
            if (eval instanceof DMNLiteralExpressionEvaluator && ((DMNLiteralExpressionEvaluator)eval).isFunctionDefinition()) {
                CompiledExpression fexpr = ((DMNLiteralExpressionEvaluator)eval).getExpression();
                FEELFunction feelFunction = ctx.getFeelHelper().evaluateFunctionDef(ctx, fexpr, model, (DMNElement)funcDef, (Msg.Message)Msg.FUNC_DEF_COMPILATION_ERR, functionName, node.getIdentifierString());
                DMNInvocationEvaluator invoker = new DMNInvocationEvaluator(node.getName(), (DMNElement)node.getSource(), functionName, null, (fctx, fname) -> feelFunction, null);
                for (InformationItem p : funcDef.getFormalParameter()) {
                    invoker.addParameter(p.getName(), func.getParameterType(p.getName()), (em, dr) -> new EvaluatorResultImpl(dr.getContext().get(p.getName()), EvaluatorResult.ResultType.SUCCESS));
                }
                eval = invoker;
            }
            func.setEvaluator(eval);
            DMNFunctionDefinitionEvaluator dMNFunctionDefinitionEvaluator = func;
            return dMNFunctionDefinitionEvaluator;
        }
        finally {
            ctx.exitFrame();
        }
    }

    private DMNExpressionEvaluator compileFunctionDefinitionJAVA(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String functionName, FunctionDefinition funcDef) {
        if (funcDef.getExpression() instanceof Context) {
            Context context = (Context)funcDef.getExpression();
            String clazz = null;
            String method = null;
            for (ContextEntry ce : context.getContextEntry()) {
                if (ce.getVariable() == null || ce.getVariable().getName() == null || ce.getExpression() == null || !(ce.getExpression() instanceof LiteralExpression)) continue;
                if (ce.getVariable().getName().equals("class")) {
                    clazz = this.stripQuotes(((LiteralExpression)ce.getExpression()).getText().trim());
                    continue;
                }
                if (!ce.getVariable().getName().equals("method signature")) continue;
                method = this.stripQuotes(((LiteralExpression)ce.getExpression()).getText().trim());
            }
            if (clazz != null && method != null) {
                String params = funcDef.getFormalParameter().stream().map(p -> p.getName()).collect(Collectors.joining(","));
                String expr = String.format("function(%s) external { java: { class: \"%s\", method signature: \"%s\" }}", params, clazz, method);
                try {
                    FEELFunction feelFunction = ctx.getFeelHelper().evaluateFunctionDef(ctx, expr, model, (DMNElement)funcDef, (Msg.Message)Msg.FUNC_DEF_COMPILATION_ERR, functionName, node.getIdentifierString());
                    if (feelFunction != null) {
                        ((BaseFEELFunction)feelFunction).setName(functionName);
                    }
                    DMNInvocationEvaluator invoker = new DMNInvocationEvaluator(node.getName(), (DMNElement)node.getSource(), functionName, null, (fctx, fname) -> feelFunction, null);
                    DMNFunctionDefinitionEvaluator func = new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
                    for (InformationItem p2 : funcDef.getFormalParameter()) {
                        DMNCompilerHelper.checkVariableName(model, (NamedElement)p2, p2.getName());
                        DMNType dmnType = this.compiler.resolveTypeRef(model, (NamedElement)p2, (DMNModelInstrumentedBase)p2, p2.getTypeRef());
                        func.addParameter(p2.getName(), dmnType);
                        invoker.addParameter(p2.getName(), dmnType, (em, dr) -> new EvaluatorResultImpl(dr.getContext().get(p2.getName()), EvaluatorResult.ResultType.SUCCESS));
                    }
                    func.setEvaluator(invoker);
                    return func;
                }
                catch (Throwable e) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, e, null, Msg.FUNC_DEF_COMPILATION_ERR, functionName, node.getIdentifierString(), "Exception raised: " + e.getClass().getSimpleName());
                }
            } else {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_MISSING_ENTRY, functionName, node.getIdentifierString());
            }
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_BODY_NOT_CONTEXT, node.getIdentifierString());
        }
        return new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
    }

    private DMNExpressionEvaluator compileFunctionDefinitionPMML(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String functionName, FunctionDefinition funcDef) {
        if (funcDef.getExpression() instanceof Context) {
            Context context = (Context)funcDef.getExpression();
            String pmmlDocument = null;
            String pmmlModel = null;
            for (ContextEntry ce : context.getContextEntry()) {
                if (ce.getVariable() == null || ce.getVariable().getName() == null || !(ce.getExpression() instanceof LiteralExpression)) continue;
                LiteralExpression ceLitExpr = (LiteralExpression)ce.getExpression();
                if (ce.getVariable().getName().equals("document")) {
                    if (ceLitExpr.getText() == null) continue;
                    pmmlDocument = this.stripQuotes(ceLitExpr.getText().trim());
                    continue;
                }
                if (!ce.getVariable().getName().equals("model") || ceLitExpr.getText() == null) continue;
                pmmlModel = this.stripQuotes(ceLitExpr.getText().trim());
            }
            String nameLookup = pmmlDocument;
            Optional<Import> lookupImport = model.getDefinitions().getImport().stream().filter(x -> x.getName().equals(nameLookup)).findFirst();
            if (lookupImport.isPresent()) {
                List pmmlModelNames;
                Import theImport = lookupImport.get();
                logger.trace("theImport: {}", (Object)theImport);
                Resource pmmlResource = DMNCompilerImpl.resolveRelativeResource(this.getRootClassLoader(), model, theImport, (DMNModelInstrumentedBase)funcDef, ctx.getRelativeResolver());
                logger.trace("pmmlResource: {}", (Object)pmmlResource);
                DMNImportPMMLInfo pmmlInfo = model.getPmmlImportInfo().get(pmmlDocument);
                logger.trace("pmmlInfo: {}", (Object)pmmlInfo);
                if ((pmmlModel == null || pmmlModel.isEmpty()) && (pmmlModelNames = pmmlInfo.getModels().stream().map(PMMLModelInfo::getName).filter(x -> x != null).collect(Collectors.toList())).size() > 0) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_PMML_MISSING_MODEL_NAME, pmmlModelNames.stream().collect(Collectors.joining(",")));
                }
                AbstractPMMLInvocationEvaluator invoker = AbstractPMMLInvocationEvaluator.PMMLInvocationEvaluatorFactory.newInstance(model, this.getRootClassLoader(), (DMNElement)funcDef, pmmlResource, pmmlModel, pmmlInfo);
                DMNFunctionDefinitionEvaluator func = new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
                for (InformationItem p : funcDef.getFormalParameter()) {
                    DMNCompilerHelper.checkVariableName(model, (NamedElement)p, p.getName());
                    DMNType dmnType = this.compiler.resolveTypeRef(model, (NamedElement)p, (DMNModelInstrumentedBase)p, p.getTypeRef());
                    func.addParameter(p.getName(), dmnType);
                    invoker.addParameter(p.getName(), dmnType);
                }
                func.setEvaluator(invoker);
                return func;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_PMML_MISSING_ENTRY, functionName, node.getIdentifierString());
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_BODY_NOT_CONTEXT, node.getIdentifierString());
        }
        return new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
    }

    private String stripQuotes(String trim) {
        return trim.startsWith("\"") && trim.endsWith("\"") && trim.length() >= 2 ? trim.substring(1, trim.length() - 1) : trim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DMNExpressionEvaluator compileDecisionTable(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String dtName, DecisionTable dt) {
        CompiledExpression compiledExpression;
        BaseDMNTypeImpl typeRef;
        ArrayList<DTInputClause> inputs = new ArrayList<DTInputClause>();
        ArrayList<DMNType> inputTypes = new ArrayList<DMNType>();
        int index = 0;
        for (InputClause ic : dt.getInput()) {
            ++index;
            String inputExpressionText = ic.getInputExpression().getText();
            String inputValuesText = Optional.ofNullable(ic.getInputValues()).map(UnaryTests::getText).orElse(null);
            List<UnaryTest> inputValues = null;
            DMNType inputType = model.getTypeRegistry().unknown();
            if (inputValuesText != null) {
                inputValues = this.textToUnaryTestList(ctx, inputValuesText, model, (DMNElement)ic, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_INPUT_CLAUSE_IDX, inputValuesText, node.getIdentifierString(), index);
            } else if (ic.getInputExpression().getTypeRef() != null) {
                QName inputExpressionTypeRef = ic.getInputExpression().getTypeRef();
                QName resolvedInputExpressionTypeRef = DMNCompilerImpl.getNamespaceAndName((DMNModelInstrumentedBase)ic.getInputExpression(), model.getImportAliasesForNS(), inputExpressionTypeRef, model.getNamespace());
                typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().resolveType(resolvedInputExpressionTypeRef.getNamespaceURI(), resolvedInputExpressionTypeRef.getLocalPart());
                inputType = typeRef;
                inputValues = typeRef.getAllowedValuesFEEL();
            }
            CompiledExpression compiledInput = ctx.getFeelHelper().compileFeelExpression(ctx, inputExpressionText, model, (DMNElement)dt, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_INPUT_CLAUSE_IDX, inputExpressionText, dtName, index);
            inputs.add(new DTInputClause(inputExpressionText, inputValuesText, inputValues, compiledInput, inputType.isCollection()));
            inputTypes.add(inputType);
        }
        ArrayList<DTOutputClause> outputs = new ArrayList<DTOutputClause>();
        index = 0;
        boolean hasOutputValues = false;
        for (Object oc : dt.getOutput()) {
            String outputName = oc.getName();
            if (outputName != null) {
                DMNCompilerHelper.checkVariableName(model, node.getSource(), outputName);
            }
            String id = oc.getId();
            String outputValuesText = Optional.ofNullable(oc.getOutputValues()).map(UnaryTests::getText).orElse(null);
            String defaultValue = oc.getDefaultOutputEntry() != null ? oc.getDefaultOutputEntry().getText() : null;
            typeRef = DMNEvaluatorCompiler.inferTypeRef(model, dt, (OutputClause)oc);
            List<UnaryTest> outputValues = null;
            if (outputValuesText != null) {
                outputValues = this.textToUnaryTestList(ctx, outputValuesText, model, (DMNElement)oc, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_OUTPUT_CLAUSE_IDX, outputValuesText, node.getIdentifierString(), ++index);
            } else if (typeRef != model.getTypeRegistry().unknown()) {
                outputValues = typeRef.getAllowedValuesFEEL();
            }
            if (outputValues != null && !outputValues.isEmpty()) {
                hasOutputValues = true;
            }
            outputs.add(new DTOutputClause(outputName, id, outputValues, defaultValue, typeRef.getFeelType(), typeRef.isCollection()));
        }
        if (dt.getHitPolicy().equals((Object)HitPolicy.PRIORITY) && !hasOutputValues) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, dt.getParent(), model, null, null, Msg.MISSING_OUTPUT_VALUES, dtName);
        }
        ArrayList<DTDecisionRule> rules = new ArrayList<DTDecisionRule>();
        index = 0;
        for (DecisionRule dr : dt.getRule()) {
            DTDecisionRule rule = new DTDecisionRule(index);
            for (int i = 0; i < dr.getInputEntry().size(); ++i) {
                List<Object> tests;
                UnaryTests ut = (UnaryTests)dr.getInputEntry().get(i);
                if (ut == null || ut.getText() == null || ut.getText().isEmpty()) {
                    tests = Collections.emptyList();
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ut, model, null, null, Msg.DTABLE_EMPTY_ENTRY, dt.getRule().indexOf(dr) + 1, dr.getInputEntry().indexOf(ut) + 1, dt.getParentDRDElement().getIdentifierString());
                } else {
                    ctx.enterFrame();
                    try {
                        ctx.setVariable("?", (DMNType)inputTypes.get(i));
                        tests = this.textToUnaryTestList(ctx, ut.getText(), model, (DMNElement)dr, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_RULE_IDX, ut.getText(), node.getIdentifierString(), index + 1);
                    }
                    finally {
                        ctx.exitFrame();
                    }
                }
                rule.getInputEntry().add((c, x) -> tests.stream().anyMatch(t -> {
                    Boolean result = (Boolean)t.apply(c, x);
                    return result != null && result != false;
                }));
            }
            for (Object le : dr.getOutputEntry()) {
                String expressionText = le.getText();
                if (expressionText == null || expressionText.isEmpty()) {
                    expressionText = "null";
                }
                compiledExpression = ctx.getFeelHelper().compileFeelExpression(ctx, expressionText, model, (DMNElement)dr, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_RULE_IDX, expressionText, dtName, index + 1);
                rule.getOutputEntry().add(compiledExpression);
            }
            rules.add(rule);
            ++index;
        }
        String policy = dt.getHitPolicy().value() + (dt.getAggregation() != null ? " " + dt.getAggregation().value() : "");
        org.kie.dmn.feel.runtime.decisiontables.HitPolicy hp = org.kie.dmn.feel.runtime.decisiontables.HitPolicy.fromString((String)policy);
        List<String> parameterNames = DMNEvaluatorCompiler.getParameters(model, node, dt);
        ArrayList<CompiledExpression> compiledParameterNames = new ArrayList<CompiledExpression>();
        for (String pName : parameterNames) {
            compiledExpression = ctx.getFeelHelper().compileFeelExpression(ctx, pName, model, (DMNElement)dt, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_PARAM, pName, dtName);
            compiledParameterNames.add(compiledExpression);
        }
        FEEL feelInstance = ctx.getFeelHelper().newFEELInstance();
        DecisionTableImpl dti = new DecisionTableImpl(dtName, parameterNames, inputs, outputs, rules, hp, feelInstance);
        dti.setCompiledParameterNames(compiledParameterNames);
        DTInvokerFunction dtf = new DTInvokerFunction(dti);
        DMNDTExpressionEvaluator dtee = new DMNDTExpressionEvaluator(node, feelInstance, dtf);
        return dtee;
    }

    public static BaseDMNTypeImpl inferTypeRef(DMNModelImpl model, DecisionTable dt, OutputClause oc) {
        QName inferredTypeRef;
        BaseDMNTypeImpl typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().unknown();
        if (oc.getTypeRef() != null) {
            QName outputExpressionTypeRef = oc.getTypeRef();
            QName resolvedOutputExpressionTypeRef = DMNCompilerImpl.getNamespaceAndName((DMNModelInstrumentedBase)oc, model.getImportAliasesForNS(), outputExpressionTypeRef, model.getNamespace());
            typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().resolveType(resolvedOutputExpressionTypeRef.getNamespaceURI(), resolvedOutputExpressionTypeRef.getLocalPart());
            if (typeRef == null) {
                typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().unknown();
            }
        } else if (dt.getOutput().size() == 1 && (dt.getParent() instanceof Decision || dt.getParent() instanceof BusinessKnowledgeModel || dt.getParent() instanceof ContextEntry) && (inferredTypeRef = DMNEvaluatorCompiler.recurseUpToInferTypeRef(model, oc, (DMNElement)dt)) != null) {
            QName resolvedInferredTypeRef = DMNCompilerImpl.getNamespaceAndName((DMNModelInstrumentedBase)oc, model.getImportAliasesForNS(), inferredTypeRef, model.getNamespace());
            typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().resolveType(resolvedInferredTypeRef.getNamespaceURI(), resolvedInferredTypeRef.getLocalPart());
        }
        return typeRef;
    }

    public static List<String> getParameters(DMNModelImpl model, DMNBaseNode node, DecisionTable dt) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        if (node instanceof BusinessKnowledgeModelNode) {
            parameterNames.addAll(((BusinessKnowledgeModelNode)node).getBusinessKnowledModel().getEncapsulatedLogic().getFormalParameter().stream().map(f -> f.getName()).collect(Collectors.toList()));
        } else {
            for (Map.Entry<String, DMNNode> depEntry : node.getDependencies().entrySet()) {
                if (depEntry.getValue().getModelNamespace().equals(node.getModelNamespace())) {
                    parameterNames.add(depEntry.getKey());
                    continue;
                }
                Optional<String> importAlias = model.getImportAliasFor(depEntry.getValue().getModelNamespace(), depEntry.getValue().getModelName());
                if (!importAlias.isPresent()) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, dt.getParent(), model, null, null, Msg.IMPORT_NOT_FOUND_FOR_NODE_MISSING_ALIAS, new QName(depEntry.getValue().getModelNamespace(), depEntry.getValue().getModelName()), node);
                    return null;
                }
                parameterNames.add(importAlias.get() + "." + depEntry.getKey());
            }
        }
        return parameterNames;
    }

    private static QName recurseUpToInferTypeRef(DMNModelImpl model, OutputClause originalElement, DMNElement recursionIdx) {
        if (recursionIdx.getParent() instanceof Decision) {
            InformationItem parentVariable = ((Decision)recursionIdx.getParent()).getVariable();
            if (parentVariable != null) {
                return DMNEvaluatorCompiler.variableTypeRefOrErrIfNull(model, parentVariable);
            }
            return null;
        }
        if (recursionIdx.getParent() instanceof BusinessKnowledgeModel) {
            InformationItem parentVariable = ((BusinessKnowledgeModel)recursionIdx.getParent()).getVariable();
            if (parentVariable != null) {
                return DMNEvaluatorCompiler.variableTypeRefOrErrIfNull(model, parentVariable);
            }
            return null;
        }
        if (recursionIdx.getParent() instanceof ContextEntry) {
            ContextEntry parentCtxEntry = (ContextEntry)recursionIdx.getParent();
            if (parentCtxEntry.getVariable() != null) {
                return DMNEvaluatorCompiler.variableTypeRefOrErrIfNull(model, parentCtxEntry.getVariable());
            }
            Context parentCtx = (Context)parentCtxEntry.getParent();
            if (((ContextEntry)parentCtx.getContextEntry().get(parentCtx.getContextEntry().size() - 1)).equals(parentCtxEntry)) {
                return DMNEvaluatorCompiler.recurseUpToInferTypeRef(model, originalElement, (DMNElement)parentCtx);
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)parentCtxEntry, model, null, null, Msg.MISSING_VARIABLE_ON_CONTEXT, parentCtxEntry);
            return null;
        }
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)originalElement, model, null, null, Msg.UNKNOWN_OUTPUT_TYPE_FOR_DT_ON_NODE, originalElement.getParentDRDElement().getIdentifierString());
        return null;
    }

    private static QName variableTypeRefOrErrIfNull(DMNModelImpl model, InformationItem variable) {
        if (variable.getTypeRef() != null) {
            return variable.getTypeRef();
        }
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)variable, model, null, null, Msg.MISSING_TYPEREF_FOR_VARIABLE, variable.getName(), variable.getParentDRDElement().getIdentifierString());
        return null;
    }

    private DMNExpressionEvaluator compileLiteralExpression(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, LiteralExpression expression) {
        DMNLiteralExpressionEvaluator evaluator = null;
        if (expression.getExpressionLanguage() == null || expression.getExpressionLanguage().equals(expression.getURIFEEL())) {
            String exprText = expression.getText();
            if (exprText != null) {
                try {
                    CompiledExpression compiledExpression = ctx.getFeelHelper().compileFeelExpression(ctx, exprText, model, (DMNElement)expression, Msg.ERR_COMPILING_FEEL_EXPR_FOR_NAME_ON_NODE, exprText, exprName, node.getIdentifierString());
                    evaluator = new DMNLiteralExpressionEvaluator(compiledExpression);
                }
                catch (Throwable e) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)expression, model, e, null, Msg.ERR_COMPILING_FEEL_EXPR_FOR_NAME_ON_NODE, exprText, exprName, node.getIdentifierString(), "Exception raised: " + e.getClass().getSimpleName());
                }
            } else {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)expression, model, null, null, Msg.MISSING_EXPRESSION_FOR_NAME, exprName, node.getIdentifierString());
            }
        }
        return evaluator;
    }

    private List<UnaryTest> textToUnaryTestList(DMNCompilerContext ctx, String text, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        return ctx.getFeelHelper().evaluateUnaryTests(ctx, text, model, element, errorMsg, msgParams);
    }
}

