/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.SpecialBuiltIn;
import freemarker.core.Token;
import java.util.List;

abstract class BuiltInWithParseTimeParameters
extends SpecialBuiltIn {
    BuiltInWithParseTimeParameters() {
    }

    abstract void bindToParameters(List var1, Token var2, Token var3) throws ParseException;

    public String getCanonicalForm() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.getCanonicalForm());
        buf.append("(");
        List args = this.getArgumentsAsList();
        int size = args.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            Expression arg = (Expression)args.get(i);
            buf.append(arg.getCanonicalForm());
        }
        buf.append(")");
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return super.getNodeTypeSymbol() + "(...)";
    }

    int getParameterCount() {
        return super.getParameterCount() + this.getArgumentsCount();
    }

    Object getParameterValue(int idx) {
        int superParamCnt = super.getParameterCount();
        if (idx < superParamCnt) {
            return super.getParameterValue(idx);
        }
        int argIdx = idx - superParamCnt;
        return this.getArgumentParameterValue(argIdx);
    }

    ParameterRole getParameterRole(int idx) {
        int superParamCnt = super.getParameterCount();
        if (idx < superParamCnt) {
            return super.getParameterRole(idx);
        }
        if (idx - superParamCnt < this.getArgumentsCount()) {
            return ParameterRole.ARGUMENT_VALUE;
        }
        throw new IndexOutOfBoundsException();
    }

    protected ParseException newArgumentCountException(String ordinalityDesc, Token openParen, Token closeParen) {
        return new ParseException("?" + this.key + "(...) " + ordinalityDesc + " parameters", this.getTemplate(), openParen.beginLine, openParen.beginColumn, closeParen.endLine, closeParen.endColumn);
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        Expression clone = super.deepCloneWithIdentifierReplaced_inner(replacedIdentifier, replacement, replacementState);
        this.cloneArguments(clone, replacedIdentifier, replacement, replacementState);
        return clone;
    }

    protected abstract List getArgumentsAsList();

    protected abstract int getArgumentsCount();

    protected abstract Expression getArgumentParameterValue(int var1);

    protected abstract void cloneArguments(Expression var1, String var2, Expression var3, Expression.ReplacemenetState var4);
}

