/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkItemResolverFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkItemNodeInstance.class);
    private static boolean variableStrictEnabled = Boolean.parseBoolean(System.getProperty("org.jbpm.variable.strict", "false"));
    private static List<String> defaultOutputVariables = Arrays.asList("ActorId");
    private Map<String, ContextInstance> contextInstances = new HashMap<String, ContextInstance>();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private long workItemId = -1L;
    protected transient WorkItem workItem;
    private long exceptionHandlingProcessInstanceId = -1L;
    private int triggerCount = 0;

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public WorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId >= 0L) {
            this.workItem = ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void internalSetWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public void internalSetWorkItem(WorkItem workItem) {
        this.workItem = workItem;
    }

    @Override
    public boolean isInversionOfControl() {
        return false;
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
            return;
        }
        WorkItemNode workItemNode = this.getWorkItemNode();
        this.createWorkItem(workItemNode);
        if (workItemNode.isWaitForCompletion()) {
            this.addWorkItemListener();
        }
        WorkItemManager workItemManager = (WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager();
        String deploymentId = (String)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("deploymentId");
        this.workItem.setDeploymentId(deploymentId);
        this.workItem.setNodeInstanceId(this.getId());
        this.workItem.setNodeId(this.getNodeId());
        this.processWorkItemHandler(() -> workItemManager.internalExecuteWorkItem(this.workItem));
        if (!workItemNode.isWaitForCompletion()) {
            this.triggerCompleted();
        }
        this.workItemId = this.workItem.getId();
    }

    private void processWorkItemHandler(Runnable handler) {
        if (this.isInversionOfControl()) {
            this.getProcessInstance().getKnowledgeRuntime().update(this.getProcessInstance().getKnowledgeRuntime().getFactHandle((Object)this), (Object)this);
        } else {
            try {
                handler.run();
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
            catch (ProcessWorkItemHandlerException handlerException) {
                if (this.triggerCount++ < handlerException.getRetries() + 1) {
                    this.workItemId = this.workItem.getId();
                    this.handleWorkItemHandlerException(handlerException, this.workItem);
                }
                throw handlerException;
            }
            catch (Exception e) {
                String exceptionName = e.getClass().getName();
                ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
                if (exceptionScopeInstance == null) {
                    throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
                }
                this.workItemId = this.workItem.getId();
                exceptionScopeInstance.handleException(exceptionName, e);
            }
        }
    }

    protected WorkItem createWorkItem(WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        this.workItem = new WorkItemImpl();
        this.workItem.setName(work.getName());
        this.workItem.setProcessInstanceId(this.getProcessInstance().getId());
        this.workItem.setParameters(new HashMap<String, Object>(work.getParameters()));
        if (this.dynamicParameters != null) {
            this.workItem.getParameters().putAll(this.dynamicParameters);
        }
        this.setWorkItemParameters(workItemNode);
        return this.workItem;
    }

    protected void setWorkItemParameters(WorkItemNode workItemNode) {
        this.setWorkItemParametersFromDataAssociations(workItemNode);
        this.setWorkItemParametersFromStringReplacement(workItemNode);
    }

    protected void setWorkItemParametersFromDataAssociations(WorkItemNode workItemNode) {
        for (DataAssociation association : workItemNode.getInAssociations()) {
            if (association.getTransformation() != null) {
                Object parameterValue;
                Transformation transformation = association.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer == null || (parameterValue = transformer.transform(transformation.getCompiledExpression(), this.getSourceParameters(association))) == null) continue;
                this.workItem.setParameter(association.getTarget(), parameterValue);
                continue;
            }
            if (association.getAssignments() == null || association.getAssignments().isEmpty()) {
                Object parameterValue = null;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getSources().get(0));
                if (variableScopeInstance != null) {
                    parameterValue = variableScopeInstance.getVariable(association.getSources().get(0));
                } else {
                    try {
                        parameterValue = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    }
                    catch (Throwable t) {
                        logger.error("Could not find variable scope for variable {}", (Object)association.getSources().get(0));
                        logger.error("when trying to execute Work Item {}", (Object)workItemNode.getWork().getName());
                        logger.error("Continuing without setting parameter.");
                    }
                }
                if (parameterValue == null) continue;
                this.workItem.setParameter(association.getTarget(), parameterValue);
                continue;
            }
            Iterator<Assignment> it = association.getAssignments().iterator();
            while (it.hasNext()) {
                this.handleAssignment(it.next());
            }
        }
    }

    protected void setWorkItemParametersFromStringReplacement(WorkItemNode workItemNode) {
        for (Map.Entry entry : this.workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVELSafeHelper.getEvaluator().eval(paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    logger.error("Could not find variable scope for variable {}", (Object)paramName);
                    logger.error("when trying to replace variable in string for Work Item {}", (Object)workItemNode.getWork().getName());
                    logger.error("Continuing without setting parameter.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            this.workItem.setParameter((String)entry.getKey(), (Object)s);
        }
    }

    private void handleAssignment(Assignment assignment) {
        AssignmentAction action = (AssignmentAction)assignment.getMetaData("Action");
        try {
            org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            context.setNodeInstance((NodeInstance)this);
            action.execute(this.getWorkItem(), (ProcessContext)context);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to execute Assignment", e);
        }
    }

    public void triggerCompleted(WorkItem workItem) {
        this.workItem = workItem;
        WorkItemNode workItemNode = this.getWorkItemNode();
        if (workItemNode != null && workItem.getState() == 2) {
            this.updateVariablesFromResult(workItem, workItemNode);
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", workItem.getName());
            this.mapDynamicOutputData(workItem.getResults());
        }
        if (this.isInversionOfControl()) {
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            kruntime.update(kruntime.getFactHandle((Object)this), (Object)this);
        } else {
            this.triggerCompleted();
        }
    }

    protected void updateVariablesFromResult(WorkItem workItem, WorkItemNode workItemNode) {
        this.validateWorkItemResultVariable(this.getProcessInstance().getProcessName(), workItemNode.getOutAssociations(), workItem);
        for (DataAssociation association : this.getWorkItemNode().getOutAssociations()) {
            if (association.getTransformation() != null) {
                Transformation transformation = association.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer == null) continue;
                Object parameterValue = transformer.transform(transformation.getCompiledExpression(), workItem.getResults());
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                if (variableScopeInstance != null && parameterValue != null) {
                    variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), parameterValue);
                    variableScopeInstance.setVariable(association.getTarget(), parameterValue);
                } else {
                    logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                    logger.warn("when trying to complete Work Item {}", (Object)workItem.getName());
                    logger.warn("Continuing without setting variable.");
                }
                if (parameterValue == null) continue;
                workItem.setParameter(association.getTarget(), parameterValue);
                continue;
            }
            if (association.getAssignments() == null || association.getAssignments().isEmpty()) {
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                if (variableScopeInstance != null) {
                    Variable varDef;
                    DataType dataType;
                    Object value = workItem.getResult(association.getSources().get(0));
                    if (value == null) {
                        try {
                            value = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new WorkItemResolverFactory((org.kie.api.runtime.process.WorkItem)workItem));
                        }
                        catch (Throwable parameterValue) {
                            // empty catch block
                        }
                    }
                    if (!(dataType = (varDef = variableScopeInstance.getVariableScope().findVariable(association.getTarget())).getType()).getStringType().endsWith("java.lang.Object") && !dataType.getStringType().endsWith("Object") && value instanceof String) {
                        value = dataType.readValue((String)value);
                    } else {
                        variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), value);
                    }
                    variableScopeInstance.setVariable(association.getTarget(), value);
                    continue;
                }
                logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                logger.warn("when trying to complete Work Item {}", (Object)workItem.getName());
                logger.warn("Continuing without setting variable.");
                continue;
            }
            try {
                Iterator<Assignment> it = association.getAssignments().iterator();
                while (it.hasNext()) {
                    this.handleAssignment(it.next());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void cancel() {
        WorkItem workItem = this.getWorkItem();
        if (workItem != null && workItem.getState() != 2 && workItem.getState() != 3) {
            try {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAbortWorkItem(this.workItemId);
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
        }
        if (this.exceptionHandlingProcessInstanceId > -1L) {
            ProcessInstance processInstance = null;
            KieRuntime kruntime = this.getKieRuntimeForSubprocess();
            processInstance = (ProcessInstance)kruntime.getProcessInstance(this.exceptionHandlingProcessInstanceId);
            if (processInstance != null) {
                processInstance.setState(3);
            }
        }
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
        this.addExceptionProcessListener();
    }

    private void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", this, false);
        this.getProcessInstance().addEventListener("workItemAborted", this, false);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("workItemCompleted", this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", this, false);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((WorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((WorkItem)event);
        } else if (("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId).equals(type)) {
            this.exceptionHandlingCompleted((ProcessInstance)event, null);
        } else if (type.equals("RuleFlow-Activate" + this.getProcessInstance().getProcessId() + "-" + this.getNode().getMetaData().get("UniqueId"))) {
            this.trigger(null, "DROOLS_DEFAULT");
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        if (this.exceptionHandlingProcessInstanceId > -1L) {
            return new String[]{"workItemCompleted", "processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId};
        }
        return new String[]{"workItemCompleted"};
    }

    public void workItemAborted(WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public void workItemCompleted(WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            String nodeName = "[Dynamic]";
            WorkItem workItem = this.getWorkItem();
            if (workItem != null) {
                nodeName = nodeName + " " + workItem.getParameter("TaskName");
            }
            return nodeName;
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(org.jbpm.process.core.Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getWorkItemNode();
    }

    protected Map<String, Object> getSourceParameters(DataAssociation association) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String sourceParam : association.getSources()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", sourceParam);
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(sourceParam);
            } else {
                try {
                    parameterValue = MVELSafeHelper.getEvaluator().eval(sourceParam, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.warn("Could not find variable scope for variable {}", (Object)sourceParam);
                }
            }
            if (parameterValue == null) continue;
            parameters.put(association.getTarget(), parameterValue);
        }
        return parameters;
    }

    public void validateWorkItemResultVariable(String processName, List<DataAssociation> outputs, WorkItem workItem) {
        if (!variableStrictEnabled || workItem.getResults().isEmpty()) {
            return;
        }
        ArrayList<String> outputNames = new ArrayList<String>();
        for (DataAssociation association : outputs) {
            if (association.getSources() != null) {
                outputNames.add(association.getSources().get(0));
            }
            if (association.getAssignments() == null) continue;
            Iterator<Assignment> it = association.getAssignments().iterator();
            while (it.hasNext()) {
                outputNames.add(it.next().getFrom());
            }
        }
        for (String outputName : workItem.getResults().keySet()) {
            if (outputNames.contains(outputName) || defaultOutputVariables.contains(outputName)) continue;
            throw new IllegalArgumentException("Data output '" + outputName + "' is not defined in process '" + processName + "' for task '" + workItem.getParameter("NodeName") + "'");
        }
    }

    private void handleWorkItemHandlerException(ProcessWorkItemHandlerException handlerException, WorkItem workItem) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("DeploymentId", workItem.getDeploymentId());
        parameters.put("ProcessInstanceId", workItem.getProcessInstanceId());
        parameters.put("WorkItemId", workItem.getId());
        parameters.put("NodeInstanceId", this.getId());
        parameters.put("ErrorMessage", handlerException.getMessage());
        parameters.put("Error", (Object)handlerException);
        parameters.putAll(workItem.getParameters());
        KieRuntime kruntime = this.getKieRuntimeForSubprocess();
        ProcessInstance processInstance = (ProcessInstance)kruntime.createProcessInstance(handlerException.getProcessId(), parameters);
        this.exceptionHandlingProcessInstanceId = processInstance.getId();
        ((ProcessInstanceImpl)processInstance).setMetaData("ParentProcessInstanceId", this.getProcessInstance().getId());
        ((ProcessInstanceImpl)processInstance).setMetaData("ParentNodeInstanceId", this.getUniqueId());
        ((ProcessInstanceImpl)processInstance).setParentProcessInstanceId(this.getProcessInstance().getId());
        ((ProcessInstanceImpl)processInstance).setSignalCompletion(true);
        kruntime.startProcessInstance(processInstance.getId());
        if (processInstance.getState() == 2 || processInstance.getState() == 3) {
            this.exceptionHandlingCompleted(processInstance, handlerException);
        } else {
            this.addExceptionProcessListener();
        }
    }

    private void exceptionHandlingCompleted(ProcessInstance processInstance, ProcessWorkItemHandlerException handlerException) {
        if (handlerException == null) {
            handlerException = (ProcessWorkItemHandlerException)((Object)((WorkflowProcessInstance)processInstance).getVariable("Error"));
        }
        switch (handlerException.getStrategy()) {
            case ABORT: {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).abortWorkItem(this.getWorkItem().getId());
                break;
            }
            case RETHROW: {
                String exceptionName = handlerException.getCause().getClass().getName();
                ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
                if (exceptionScopeInstance == null) {
                    throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute work item " + handlerException.getMessage(), handlerException.getCause());
                }
                exceptionScopeInstance.handleException(exceptionName, handlerException.getCause());
                break;
            }
            case RETRY: {
                HashMap<String, Object> parameters = new HashMap<String, Object>(this.getWorkItem().getParameters());
                parameters.putAll(((WorkflowProcessInstanceImpl)processInstance).getVariables());
                WorkItemManager workItemManager = (WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager();
                this.processWorkItemHandler(() -> workItemManager.retryWorkItem(Long.valueOf(this.getWorkItem().getId()), parameters));
                break;
            }
            case COMPLETE: {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).completeWorkItem(this.getWorkItem().getId(), ((WorkflowProcessInstanceImpl)processInstance).getVariables());
                break;
            }
        }
    }

    public void addExceptionProcessListener() {
        if (this.exceptionHandlingProcessInstanceId > -1L) {
            this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId, this, true);
        }
    }

    public void removeExceptionProcessListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId, this, true);
    }

    public long getExceptionHandlingProcessInstanceId() {
        return this.exceptionHandlingProcessInstanceId;
    }

    public void internalSetProcessInstanceId(long processInstanceId) {
        this.exceptionHandlingProcessInstanceId = processInstanceId;
    }

    protected KieRuntime getKieRuntimeForSubprocess() {
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        RuntimeManager manager = (RuntimeManager)kruntime.getEnvironment().get("RuntimeManager");
        if (manager != null) {
            ProcessInstanceIdContext context = ProcessInstanceIdContext.get();
            String caseId = (String)kruntime.getEnvironment().get("CaseId");
            if (caseId != null) {
                context = CaseContext.get((String)caseId);
            }
            RuntimeEngine runtime = manager.getRuntimeEngine((Context)context);
            kruntime = runtime.getKieSession();
        }
        return kruntime;
    }

    public static void setVariableStrictOption(boolean turnedOn) {
        variableStrictEnabled = turnedOn;
    }
}

