/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.services.api.ProcessService;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.manager.context.CaseContext;

public class AddDataCaseFileInstanceCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335953L;
    private String deploymentId;
    private Long processInstanceId;
    private Map<String, Object> parameters;
    private AuthorizationManager authorizationManager;
    private List<String> accessRestriction;
    private transient ProcessService processService;

    public AddDataCaseFileInstanceCommand(String deploymentId, Long processInstanceId, IdentityProvider identityProvider, Map<String, Object> parameters, List<String> accessRestriction, AuthorizationManager authorizationManager, ProcessService processService) {
        super(identityProvider);
        this.deploymentId = deploymentId;
        this.processInstanceId = processInstanceId;
        this.parameters = parameters;
        this.authorizationManager = authorizationManager;
        this.accessRestriction = accessRestriction;
        this.processService = processService;
    }

    public Void execute(org.kie.api.runtime.Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        this.authorizationManager.checkDataAuthorization(caseFile.getCaseId(), caseFile, this.parameters.keySet());
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseDataAdded(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), this.parameters);
        caseFile.addAll(this.parameters);
        for (String name : this.parameters.keySet()) {
            if (this.accessRestriction != null) {
                ((CaseFileInstanceImpl)caseFile).addDataAccessRestriction(name, this.accessRestriction);
                continue;
            }
            ((CaseFileInstanceImpl)caseFile).removeDataAccessRestriction(name);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            this.processService.execute(this.deploymentId, (Context)CaseContext.get((String)caseFile.getCaseId()), (Command)new ExecutableCommand<Void>(){
                private static final long serialVersionUID = -7093369406457484236L;

                public Void execute(org.kie.api.runtime.Context context) {
                    KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                    org.jbpm.process.instance.ProcessInstance pi = (org.jbpm.process.instance.ProcessInstance)ksession.getProcessInstance(AddDataCaseFileInstanceCommand.this.processInstanceId.longValue());
                    if (pi != null) {
                        ProcessEventSupport processEventSupport = ((InternalProcessRuntime)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).getProcessEventSupport();
                        VariableScope variableScope = (VariableScope)pi.getContextContainer().getDefaultContext("VariableScope");
                        for (Map.Entry entry : AddDataCaseFileInstanceCommand.this.parameters.entrySet()) {
                            String name = "caseFile_" + (String)entry.getKey();
                            List tags = variableScope == null ? Collections.emptyList() : variableScope.tags(name);
                            processEventSupport.fireBeforeVariableChanged(name, name, null, entry.getValue(), tags, (ProcessInstance)pi, (KieRuntime)ksession);
                            processEventSupport.fireAfterVariableChanged(name, name, null, entry.getValue(), tags, (ProcessInstance)pi, (KieRuntime)ksession);
                        }
                    }
                    return null;
                }
            });
        }
        ksession.update(factHandle, (Object)caseFile);
        this.triggerRules(ksession);
        caseEventSupport.fireAfterCaseDataAdded(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), this.parameters);
        return null;
    }
}

