/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.v1_1.TImport;

public class ImportDMNResolverUtil {
    private ImportDMNResolverUtil() {
    }

    public static <T> Either<String, T> resolveImportDMN(Import _import, Collection<T> all, Function<T, QName> idExtractor) {
        String iNamespace = _import.getNamespace();
        String iName = _import.getName();
        String iModelName = (String)_import.getAdditionalAttributes().get(TImport.MODELNAME_QNAME);
        List allInNS = all.stream().filter(m -> ((QName)idExtractor.apply(m)).getNamespaceURI().equals(iNamespace)).collect(Collectors.toList());
        if (allInNS.size() == 1) {
            Object located = allInNS.get(0);
            if (iModelName == null || idExtractor.apply(located).getLocalPart().equals(iModelName)) {
                return Either.ofRight(located);
            }
            return Either.ofLeft((Object)String.format("While importing DMN for namespace: %s, name: %s, modelName: %s, located within namespace only %s but does not match for the actual name", iNamespace, iName, iModelName, idExtractor.apply(located)));
        }
        List usingNSandName = allInNS.stream().filter(m -> ((QName)idExtractor.apply(m)).getLocalPart().equals(iModelName)).collect(Collectors.toList());
        if (usingNSandName.size() == 1) {
            return Either.ofRight(usingNSandName.get(0));
        }
        if (usingNSandName.size() == 0) {
            return Either.ofLeft((Object)String.format("Could not locate required dependency while importing DMN for namespace: %s, name: %s, modelName: %s.", iNamespace, iName, iModelName));
        }
        return Either.ofLeft((Object)String.format("While importing DMN for namespace: %s, name: %s, modelName: %s, could not locate required dependency within: %s.", iNamespace, iName, iModelName, allInNS.stream().map(idExtractor).collect(Collectors.toList())));
    }

    public static ImportType whichImportType(Import _import) {
        switch (_import.getImportType()) {
            case "http://www.omg.org/spec/DMN/20151101/dmn.xsd": 
            case "http://www.omg.org/spec/DMN1-2Alpha/20160929/MODEL": 
            case "http://www.omg.org/spec/DMN/20180521/MODEL/": 
            case "https://www.omg.org/spec/DMN/20191111/MODEL/": {
                return ImportType.DMN;
            }
            case "http://www.dmg.org/PMML-3_0": 
            case "http://www.dmg.org/PMML-3_1": 
            case "http://www.dmg.org/PMML-3_2": 
            case "http://www.dmg.org/PMML-4_0": 
            case "http://www.dmg.org/PMML-4_1": 
            case "http://www.dmg.org/PMML-4_2": 
            case "http://www.dmg.org/PMML-4_3": {
                return ImportType.PMML;
            }
        }
        return ImportType.UNKNOWN;
    }

    public static enum ImportType {
        UNKNOWN,
        DMN,
        PMML;

    }
}

