/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.internal.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.core.internal.utils.MapBackedDMNContext;

public class MarshallingStubUtils {
    public static Object stubDMNResult(Object result, Function<Object, Object> stubbingWrapper) {
        if (result instanceof DMNContext) {
            HashMap<String, Object> stubbedContextValues = new HashMap<String, Object>();
            for (Map.Entry kv : ((DMNContext)result).getAll().entrySet()) {
                stubbedContextValues.put((String)kv.getKey(), MarshallingStubUtils.stubDMNResult(kv.getValue(), stubbingWrapper));
            }
            return MapBackedDMNContext.of(stubbedContextValues);
        }
        if (result instanceof Map) {
            HashMap stubbedValues = new HashMap();
            for (Map.Entry kv : ((Map)result).entrySet()) {
                stubbedValues.put(kv.getKey(), MarshallingStubUtils.stubDMNResult(kv.getValue(), stubbingWrapper));
            }
            return stubbedValues;
        }
        if (result instanceof List) {
            List stubbedValues = ((List)result).stream().map(r -> MarshallingStubUtils.stubDMNResult(r, stubbingWrapper)).collect(Collectors.toList());
            return stubbedValues;
        }
        if (result instanceof Set) {
            Set stubbedValues = ((Set)result).stream().map(r -> MarshallingStubUtils.stubDMNResult(r, stubbingWrapper)).collect(Collectors.toSet());
            return stubbedValues;
        }
        if (result != null && result.getClass().getPackage().getName().startsWith("org.kie.dmn")) {
            return stubbingWrapper.apply(result);
        }
        return result;
    }

    private MarshallingStubUtils() {
    }
}

