/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.internal.io.ResourceFactory;

public class FileKieModule
extends AbstractKieModule
implements InternalKieModule,
Serializable {
    private File file;

    public FileKieModule() {
    }

    public FileKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        super(releaseId, kieProject);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getCreationTimestamp() {
        return this.file.lastModified();
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return new File(this.file, pResourceName).exists();
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        try {
            File resource = new File(this.file, pResourceName);
            return resource.exists() ? IoUtils.readBytesFromInputStream((InputStream)new FileInputStream(resource)) : null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get bytes for: " + new File(this.file, pResourceName) + " " + e.getMessage());
        }
    }

    @Override
    public InternalResource getResource(String fileName) {
        File resource = new File(this.file, fileName);
        return resource.exists() ? (InternalResource)ResourceFactory.newFileResource((File)resource) : null;
    }

    @Override
    public Collection<String> getFileNames() {
        return IoUtils.recursiveListFile((File)this.file);
    }

    @Override
    public byte[] getBytes() {
        try {
            return IoUtils.readBytesFromInputStream((InputStream)new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "FileKieModule[releaseId=" + this.getReleaseId() + ",file=" + this.file + "]";
    }
}

