/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tomcat.dbcp.pool2.TrackedUse;

public class AbandonedTrace
implements TrackedUse {
    private final List<WeakReference<AbandonedTrace>> traceList = new ArrayList<WeakReference<AbandonedTrace>>();
    private volatile long lastUsedMillis = 0L;

    public AbandonedTrace() {
        this.init(null);
    }

    public AbandonedTrace(AbandonedTrace parent) {
        this.init(parent);
    }

    private void init(AbandonedTrace parent) {
        if (parent != null) {
            parent.addTrace(this);
        }
    }

    @Override
    public long getLastUsed() {
        return this.lastUsedMillis;
    }

    protected void setLastUsed() {
        this.lastUsedMillis = System.currentTimeMillis();
    }

    protected void setLastUsed(long lastUsedMillis) {
        this.lastUsedMillis = lastUsedMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrace(AbandonedTrace trace) {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            this.traceList.add(new WeakReference<AbandonedTrace>(trace));
        }
        this.setLastUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrace() {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            this.traceList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbandonedTrace> getTrace() {
        int size = this.traceList.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<AbandonedTrace> result = new ArrayList<AbandonedTrace>(size);
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            Iterator<WeakReference<AbandonedTrace>> iter = this.traceList.iterator();
            while (iter.hasNext()) {
                AbandonedTrace trace = (AbandonedTrace)iter.next().get();
                if (trace == null) {
                    iter.remove();
                    continue;
                }
                result.add(trace);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTrace(AbandonedTrace trace) {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            Iterator<WeakReference<AbandonedTrace>> iter = this.traceList.iterator();
            while (iter.hasNext()) {
                AbandonedTrace traceInList = (AbandonedTrace)iter.next().get();
                if (trace.equals(traceInList)) {
                    iter.remove();
                    break;
                }
                if (traceInList != null) continue;
                iter.remove();
            }
        }
    }
}

