/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(TimerNodeInstance.class);
    private long timerId;
    private TimerInstance timerInstance;

    public TimerNode getTimerNode() {
        return (TimerNode)this.getNode();
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A TimerNode only accepts default incoming connections!");
        }
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        this.timerInstance = this.createTimerInstance(kruntime);
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
        ((InternalProcessRuntime)kruntime.getProcessRuntime()).getTimerManager().registerTimer(this.timerInstance, this.getProcessInstance());
        this.timerId = this.timerInstance.getId();
    }

    protected TimerInstance createTimerInstance(InternalKnowledgeRuntime kruntime) {
        Timer timer = this.getTimerNode().getTimer();
        TimerInstance timerInstance = new TimerInstance();
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            String delay = this.resolveVariable(timer.getDelay());
            timerInstance.setDelay(businessCalendar.calculateBusinessTimeAsDuration(delay));
            if (timer.getPeriod() == null) {
                timerInstance.setPeriod(0L);
            } else {
                String period = this.resolveVariable(timer.getPeriod());
                timerInstance.setPeriod(businessCalendar.calculateBusinessTimeAsDuration(period));
            }
        } else {
            this.configureTimerInstance(timer, timerInstance);
        }
        timerInstance.setTimerId(timer.getId());
        return timerInstance;
    }

    @Override
    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        if ("timerTriggered".equals(type) && (timer = (TimerInstance)event).getId() == this.timerId) {
            this.triggerCompleted(timer.getPeriod() == 0L);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    @Override
    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    @Override
    public void cancel(NodeInstance.CancelType cancelType) {
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager().cancelTimer(this.timerId);
        super.cancel(cancelType);
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }

    public TimerInstance getTimerInstance() {
        return this.timerInstance;
    }
}

