/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.MilestoneNode;

public class MilestoneNodeFactory
extends NodeFactory {
    public MilestoneNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
    }

    @Override
    protected Node createNode() {
        return new MilestoneNode();
    }

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    public MilestoneNodeFactory name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public MilestoneNodeFactory onEntryAction(String dialect, String action) {
        if (this.getMilestoneNode().getActions(dialect) != null) {
            this.getMilestoneNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getMilestoneNode().setActions("onEntry", actions);
        }
        return this;
    }

    public MilestoneNodeFactory onExitAction(String dialect, String action) {
        if (this.getMilestoneNode().getActions(dialect) != null) {
            this.getMilestoneNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getMilestoneNode().setActions("onExit", actions);
        }
        return this;
    }

    public MilestoneNodeFactory constraint(String constraint) {
        this.getMilestoneNode().setConstraint(constraint);
        return this;
    }

    public MilestoneNodeFactory timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getMilestoneNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }
}

