/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.PersistentWorkItem;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.NonTransactionalPersistentSession;

public class MapBasedPersistenceContext
implements PersistenceContext,
NonTransactionalPersistentSession {
    private Map<Long, PersistentSession> ksessions;
    private Map<Long, PersistentWorkItem> workItems;
    private boolean open = true;
    private KnowledgeSessionStorage storage;

    public MapBasedPersistenceContext(KnowledgeSessionStorage storage) {
        this.storage = storage;
        this.ksessions = new HashMap<Long, PersistentSession>();
        this.workItems = new HashMap<Long, PersistentWorkItem>();
    }

    public PersistentSession persist(PersistentSession entity) {
        if (entity.getId() == null) {
            entity.setId(this.storage.getNextStatefulKnowledgeSessionId());
        }
        this.ksessions.put(entity.getId(), entity);
        return entity;
    }

    public PersistentSession findSession(Long sessionId) {
        PersistentSession session = this.ksessions.get(sessionId);
        if (session == null) {
            session = this.storage.findSessionInfo(sessionId);
            this.ksessions.put(sessionId, session);
        }
        return session;
    }

    public void remove(PersistentSession session) {
        this.ksessions.remove(session.getId());
    }

    public boolean isOpen() {
        return this.open;
    }

    public void joinTransaction() {
    }

    public void close() {
        this.open = false;
        this.clear();
    }

    @Override
    public void clear() {
        this.clearAll();
    }

    private void clearAll() {
        this.ksessions.clear();
        this.workItems.clear();
    }

    @Override
    public List<PersistentSession> getStoredKnowledgeSessions() {
        return Collections.unmodifiableList(new ArrayList<PersistentSession>(this.ksessions.values()));
    }

    public PersistentWorkItem persist(PersistentWorkItem workItem) {
        if (workItem.getId() == null) {
            workItem.setId(this.storage.getNextWorkItemId());
        }
        this.workItems.put(workItem.getId(), workItem);
        return workItem;
    }

    @Override
    public List<PersistentWorkItem> getStoredWorkItems() {
        return Collections.unmodifiableList(new ArrayList<PersistentWorkItem>(this.workItems.values()));
    }

    public PersistentWorkItem findWorkItem(Long id) {
        PersistentWorkItem workItem = this.workItems.get(id);
        if (workItem == null) {
            workItem = this.storage.findWorkItemInfo(id);
        }
        return workItem;
    }

    public void remove(PersistentWorkItem workItem) {
        if (this.workItems.remove(workItem.getId()) != null) {
            this.storage.remove(workItem);
        }
    }

    public PersistentWorkItem merge(PersistentWorkItem workItem) {
        this.storage.saveOrUpdate(workItem);
        return workItem;
    }

    public void lock(PersistentSession session) {
        throw new UnsupportedOperationException("Map based persistence does not support locking.");
    }

    public void lock(PersistentWorkItem workItem) {
        throw new UnsupportedOperationException("Map based persistence does not support locking.");
    }
}

