/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.marshalling;

import java.util.ArrayList;
import java.util.List;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.casemgmt.impl.marshalling.CaseFileInstanceMarshallingStrategy;
import org.jbpm.document.marshalling.DocumentMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class CaseMarshallerFactory {
    private List<ObjectMarshallingStrategy> marshallers = new ArrayList<ObjectMarshallingStrategy>();
    private ClassLoader classLoader;
    private StringBuilder toString = new StringBuilder();

    private CaseMarshallerFactory() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.toString.append(this.getClass().getName()).append(".").append("builder()");
    }

    private CaseMarshallerFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.toString.append(this.getClass().getName()).append(".").append("builder(classLoader)");
    }

    public CaseMarshallerFactory withDoc() {
        this.marshallers.add((ObjectMarshallingStrategy)new DocumentMarshallingStrategy());
        this.toString.append(".withDoc()");
        return this;
    }

    public CaseMarshallerFactory withJpa(String puName) {
        this.marshallers.add((ObjectMarshallingStrategy)new JPAPlaceholderResolverStrategy(puName, this.classLoader));
        this.toString.append(".withJpa(\"" + puName + "\")");
        return this;
    }

    public CaseMarshallerFactory with(ObjectMarshallingStrategy custom) {
        this.marshallers.add(custom);
        this.toString.append(".with(new " + custom.getClass().getName() + "())");
        return this;
    }

    public ObjectMarshallingStrategy get() {
        return new CaseFileInstanceMarshallingStrategy(this.marshallers.toArray(new ObjectMarshallingStrategy[this.marshallers.size()]));
    }

    public String toString() {
        String complete = this.toString.toString();
        complete = complete + ".get();";
        return complete;
    }

    public static CaseMarshallerFactory builder(ClassLoader classLoader) {
        return new CaseMarshallerFactory(classLoader);
    }

    public static CaseMarshallerFactory builder() {
        return new CaseMarshallerFactory();
    }
}

