/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.checklist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.examples.checklist.ChecklistItem;
import org.jbpm.examples.checklist.impl.DefaultChecklistItem;
import org.jbpm.process.core.Work;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;

public final class ChecklistItemFactory {
    public static ChecklistItem createChecklistItem(Task task) {
        return new DefaultChecklistItem(ChecklistItemFactory.getText(task.getNames()), ChecklistItemFactory.getStatus(task.getTaskData().getStatus()), task.getId(), "HumanTaskNode", ChecklistItemFactory.getActors(task), task.getPriority().intValue(), task.getTaskData().getProcessId(), task.getTaskData().getProcessInstanceId(), ChecklistItemFactory.getText(task.getDescriptions()));
    }

    private static String getText(List<I18NText> texts) {
        if (texts == null) {
            return null;
        }
        for (I18NText text : texts) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            return text.getText();
        }
        return null;
    }

    private static ChecklistItem.Status getStatus(Status status) {
        switch (status) {
            case Completed: {
                return ChecklistItem.Status.Completed;
            }
            case Ready: 
            case Created: {
                return ChecklistItem.Status.Created;
            }
            case Error: 
            case Exited: 
            case Failed: 
            case Obsolete: {
                return ChecklistItem.Status.Aborted;
            }
            case Suspended: 
            case InProgress: {
                return ChecklistItem.Status.InProgress;
            }
            case Reserved: {
                return ChecklistItem.Status.Reserved;
            }
        }
        return null;
    }

    private static String getActors(Task task) {
        User actualOwner = task.getTaskData().getActualOwner();
        if (actualOwner != null) {
            return actualOwner.getId();
        }
        String result = "";
        for (OrganizationalEntity o : task.getPeopleAssignments().getPotentialOwners()) {
            if (result.length() != 0) {
                result = result + ",";
            }
            result = result + o.getId();
        }
        return result;
    }

    public static Collection<ChecklistItem> getPendingChecklistItems(WorkflowProcess process) {
        ArrayList<ChecklistItem> result = new ArrayList<ChecklistItem>();
        ChecklistItemFactory.getPendingChecklistItems(process, result, process.getId());
        return result;
    }

    private static void getPendingChecklistItems(NodeContainer container, List<ChecklistItem> result, String processId) {
        for (Node node : container.getNodes()) {
            int position;
            if (node instanceof HumanTaskNode) {
                String groupId;
                String actorId;
                Work workItem = ((HumanTaskNode)node).getWork();
                int priority = 0;
                String priorityString = (String)workItem.getParameter("Priority");
                if (priorityString != null) {
                    try {
                        priority = new Integer(priorityString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((actorId = (String)workItem.getParameter("ActorId")) != null && actorId.trim().length() == 0) {
                    actorId = null;
                }
                if ((groupId = (String)workItem.getParameter("GroupId")) != null && groupId.trim().length() == 0) {
                    groupId = null;
                }
                String actors = null;
                actors = actorId == null ? (groupId == null ? "" : groupId) : (groupId == null ? actorId : actorId + "," + groupId);
                ChecklistItem.Status status = ChecklistItem.Status.Pending;
                if (((HumanTaskNode)node).getDefaultIncomingConnections().size() == 0) {
                    status = ChecklistItem.Status.Optional;
                }
                result.add(ChecklistItemFactory.createChecklistItem((String)workItem.getParameter("TaskName"), "HumanTaskNode", actors, (String)workItem.getParameter("Comment"), priority, processId, status));
                continue;
            }
            if (node instanceof NodeContainer) {
                ChecklistItemFactory.getPendingChecklistItems((NodeContainer)((Object)node), result, processId);
                continue;
            }
            String docs = (String)node.getMetaData().get("Documentation");
            if (docs == null || (position = docs.indexOf("OrderingNb=")) < 0) continue;
            int end = docs.indexOf(";", position + 1);
            String orderingNumber = docs.substring(position + 11, end);
            ChecklistItem.Status status = ChecklistItem.Status.Pending;
            if (((NodeImpl)node).getDefaultIncomingConnections().size() == 0 && !(node instanceof StartNode)) {
                status = ChecklistItem.Status.Optional;
            }
            result.add(ChecklistItemFactory.createChecklistItem(node.getName(), node.getClass().getSimpleName(), "", orderingNumber, 0L, processId, status));
        }
    }

    public static Collection<ChecklistItem> getLoggedChecklistItems(WorkflowProcess process, List<NodeInstanceLog> nodeInstances) {
        HashMap<String, ChecklistItem> result = new HashMap<String, ChecklistItem>();
        HashMap<String, String> relevantNodes = new HashMap<String, String>();
        ChecklistItemFactory.getRelevantNodes(process, relevantNodes);
        for (NodeInstanceLog log : nodeInstances) {
            String orderingNb = (String)relevantNodes.get(log.getNodeId());
            if (orderingNb == null) continue;
            if (log.getType() == 1) {
                result.put(orderingNb, ChecklistItemFactory.createChecklistItem(log.getNodeName(), log.getNodeType(), "", orderingNb, 0L, log.getProcessId(), ChecklistItem.Status.Completed));
                continue;
            }
            if (result.get(orderingNb) != null) continue;
            result.put(orderingNb, ChecklistItemFactory.createChecklistItem(log.getNodeName(), log.getNodeType(), "", orderingNb, 0L, log.getProcessId(), ChecklistItem.Status.InProgress));
        }
        return result.values();
    }

    private static void getRelevantNodes(NodeContainer container, Map<String, String> result) {
        for (Node node : container.getNodes()) {
            int position;
            String docs;
            if (node instanceof NodeContainer) {
                ChecklistItemFactory.getRelevantNodes((NodeContainer)((Object)node), result);
            }
            if ((docs = (String)node.getMetaData().get("Documentation")) == null || (position = docs.indexOf("OrderingNb=")) < 0) continue;
            int end = docs.indexOf(";", position + 1);
            String orderingNumber = docs.substring(position + 11, end);
            String nodeId = (String)node.getMetaData().get("UniqueId");
            if (nodeId == null) {
                nodeId = ((NodeImpl)node).getUniqueId();
            }
            result.put(nodeId, orderingNumber);
        }
    }

    private static ChecklistItem createChecklistItem(String name, String type, String actors, String orderingNb, long priority, String processId, ChecklistItem.Status status) {
        return new DefaultChecklistItem(name == null ? "" : name, status, null, type, actors == null ? "" : actors, priority, processId, null, orderingNb);
    }
}

