/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.exceptions;

import java.util.HashMap;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;

public class ScriptTaskExceptionExample {
    public static final void main(String[] args) {
        ScriptTaskExceptionExample.runExample();
    }

    public static void runExample() {
        RuntimeManager manager = ScriptTaskExceptionExample.createManager();
        KieSession ksession = manager.getRuntimeEngine(null).getKieSession();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String varName = "var1";
        params.put(varName, "valueOne");
        try {
            ksession.startProcess("ExceptionScriptTask", params);
        }
        catch (WorkflowRuntimeException wfre) {
            String msg = "An exception happened in process instance [" + wfre.getProcessInstanceId() + "] of process [" + wfre.getProcessId() + "] in node [id: " + wfre.getNodeId() + ", name: " + wfre.getNodeName() + "] and variable " + varName + " had the value [" + wfre.getVariables().get(varName) + "]";
            System.out.println(msg);
        }
        manager.close();
    }

    private static RuntimeManager createManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addAsset(KieServices.Factory.get().getResources().newClassPathResource("exceptions/ScriptTaskException.bpmn2"), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }
}

