/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.kie.services.impl.query.preprocessor.UserTasksPreprocessor;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessAdminTasksPreprocessor
extends UserTasksPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessAdminTasksPreprocessor.class);
    public static final String ADMIN_USER = System.getProperty("org.jbpm.ht.admin.user", "Administrator");
    public static final String ADMIN_GROUP = System.getProperty("org.jbpm.ht.admin.group", "Administrators");
    private IdentityProvider identityProvider;
    private UserGroupCallback userGroupCallback;

    public BusinessAdminTasksPreprocessor(IdentityProvider identityProvider, UserGroupCallback userGroupCallback, DataSetMetadata metadata) {
        super(metadata);
        this.identityProvider = identityProvider;
        this.userGroupCallback = userGroupCallback;
    }

    @Override
    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null || this.userGroupCallback == null) {
            return;
        }
        if (ADMIN_USER.equals(this.identityProvider.getName())) {
            return;
        }
        List groups = Optional.ofNullable(this.userGroupCallback.getGroupsForUser(this.identityProvider.getName())).orElse(new ArrayList());
        if (groups.stream().filter(s -> s.equals(ADMIN_GROUP)).findFirst().isPresent()) {
            return;
        }
        ArrayList<String> orgEntities = new ArrayList<String>(groups);
        orgEntities.add(this.identityProvider.getName());
        ColumnFilter columnFilter = FilterFactory.equalsTo((String)"ID", orgEntities);
        LOGGER.debug("Adding column filter: {}", (Object)columnFilter);
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            lookup.addOperation(new DataSetOp[]{filter});
        }
        super.preprocess(lookup);
    }
}

