/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.Date;
import java.util.List;
import org.jbpm.query.jpa.builder.impl.AbstractQueryBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.services.task.commands.TaskSummaryQueryCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;

public class TaskSummaryQueryBuilderImpl
extends AbstractQueryBuilderImpl<TaskSummaryQueryBuilder>
implements TaskSummaryQueryBuilder {
    private final CommandExecutor executor;
    private final String userId;

    public TaskSummaryQueryBuilderImpl() {
        this.userId = null;
        this.executor = null;
    }

    public TaskSummaryQueryBuilderImpl(String userId, TaskService taskService) {
        this.executor = taskService;
        this.userId = userId;
        this.queryWhere.setAscending(QueryParameterIdentifiers.TASK_ID_LIST);
    }

    public TaskSummaryQueryBuilder activationTime(Date ... activationTime) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, "activation time", activationTime);
        return this;
    }

    public TaskSummaryQueryBuilder activationTimeRange(Date activationTimeMin, Date activationTimeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, "activation time range", activationTimeMin, activationTimeMax);
        return this;
    }

    public TaskSummaryQueryBuilder actualOwner(String ... taskOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, "task owner id", taskOwnerId);
        return this;
    }

    public TaskSummaryQueryBuilder archived(boolean archived) {
        Short realValue = archived ? new Short(1) : new Short(0);
        this.addObjectParameter(QueryParameterIdentifiers.ARCHIVED, "archived", new Short[]{realValue});
        return this;
    }

    public TaskSummaryQueryBuilder businessAdmin(String ... businessAdminId) {
        this.addObjectParameter(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, "business administrator id", businessAdminId);
        return this;
    }

    public TaskSummaryQueryBuilder createdBy(String ... createdById) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_BY_LIST, "created by id", createdById);
        return this;
    }

    public TaskSummaryQueryBuilder createdOn(Date ... createdOnDate) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_ON_LIST, "created on", createdOnDate);
        return this;
    }

    public TaskSummaryQueryBuilder createdOnRange(Date createdOnMin, Date createdOnMax) {
        this.addRangeParameters(QueryParameterIdentifiers.CREATED_ON_LIST, "created on range", createdOnMin, createdOnMax);
        return this;
    }

    public TaskSummaryQueryBuilder deploymentId(String ... deploymentId) {
        this.addObjectParameter(QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, "deployment id", deploymentId);
        return this;
    }

    public TaskSummaryQueryBuilder description(String ... description) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_DESCRIPTION_LIST, "description", description);
        for (String desc : description) {
            if (desc.length() <= 255) continue;
            throw new IllegalArgumentException("String argument is longer than 255 characters: [" + desc + "]");
        }
        return this;
    }

    public TaskSummaryQueryBuilder expirationTime(Date ... expirationTime) {
        this.addObjectParameter(QueryParameterIdentifiers.EXPIRATION_TIME_LIST, "expiration time", expirationTime);
        return this;
    }

    public TaskSummaryQueryBuilder expirationTimeRange(Date expirationTimeMin, Date expirationTimeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.EXPIRATION_TIME_LIST, "expiration time range", expirationTimeMin, expirationTimeMax);
        return this;
    }

    public TaskSummaryQueryBuilder formName(String ... formName) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_FORM_NAME_LIST, "form name", formName);
        return this;
    }

    public TaskSummaryQueryBuilder potentialOwner(String ... potentialOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, "potential owner id", potentialOwnerId);
        return this;
    }

    public TaskSummaryQueryBuilder processInstanceId(long ... processInstanceId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return this;
    }

    public TaskSummaryQueryBuilder name(String ... names) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_NAME_LIST, "task name", names);
        for (String name : names) {
            if (name.length() <= 255) continue;
            throw new IllegalArgumentException("String argument is longer than 255 characters: [" + name + "]");
        }
        return this;
    }

    public TaskSummaryQueryBuilder priority(int ... priority) {
        this.addIntParameter(QueryParameterIdentifiers.TASK_PRIORITY_LIST, "priority", priority);
        return this;
    }

    public TaskSummaryQueryBuilder processId(String ... processId) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, "process id", processId);
        return this;
    }

    public TaskSummaryQueryBuilder processInstanceIdRange(Long processInstanceIdMin, Long processInstanceIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id range", processInstanceIdMin, processInstanceIdMax);
        return this;
    }

    public TaskSummaryQueryBuilder processSessionId(long ... processSessionId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_SESSION_ID_LIST, "process session id", processSessionId);
        return this;
    }

    public TaskSummaryQueryBuilder skippable(boolean skippable) {
        this.addObjectParameter(QueryParameterIdentifiers.SKIPPABLE, "skippable", new Boolean[]{skippable});
        return this;
    }

    public TaskSummaryQueryBuilder stakeHolder(String ... stakeHolderId) {
        this.addObjectParameter(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, "stakeholder id", stakeHolderId);
        return this;
    }

    public TaskSummaryQueryBuilder status(Status ... status) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_STATUS_LIST, "status", status);
        return this;
    }

    public TaskSummaryQueryBuilder subject(String ... subjects) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_SUBJECT_LIST, "subject", subjects);
        for (String subject : subjects) {
            if (subject.length() <= 255) continue;
            throw new IllegalArgumentException("String argument is longer than 255 characters: [" + subject + "]");
        }
        return this;
    }

    public TaskSummaryQueryBuilder subTaskStrategy(SubTasksStrategy ... subTasksStrategy) {
        this.addObjectParameter(QueryParameterIdentifiers.SUB_TASKS_STRATEGY, "sub tasks strategy", subTasksStrategy);
        return this;
    }

    public TaskSummaryQueryBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public TaskSummaryQueryBuilder taskIdRange(Long taskIdMin, Long taskIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ID_LIST, "task id range", taskIdMin, taskIdMax);
        return this;
    }

    public TaskSummaryQueryBuilder taskParentId(long ... taskParentId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_PARENT_ID_LIST, "task parent id", taskParentId);
        return this;
    }

    public TaskSummaryQueryBuilder taskType(String ... taskType) {
        this.addObjectParameter(QueryParameterIdentifiers.TYPE_LIST, "created on", taskType);
        return this;
    }

    public TaskSummaryQueryBuilder variableName(String ... varName) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_VARIABLE_NAME_ID_LIST, "task variable name", varName);
        return this;
    }

    public TaskSummaryQueryBuilder variableValue(String ... varValue) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_VARIABLE_VALUE_ID_LIST, "task variable value", varValue);
        return this;
    }

    public TaskSummaryQueryBuilder workItemId(long ... workItemId) {
        this.addLongParameter(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "work item id", workItemId);
        return this;
    }

    public TaskSummaryQueryBuilder clear() {
        super.clear();
        this.getQueryWhere().setAscending(QueryParameterIdentifiers.TASK_ID_LIST);
        return this;
    }

    public TaskSummaryQueryBuilder ascending(TaskSummaryQueryBuilder.OrderBy field) {
        String listId = this.getOrderByListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public TaskSummaryQueryBuilder descending(TaskSummaryQueryBuilder.OrderBy field) {
        String listId = this.getOrderByListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String getOrderByListId(TaskSummaryQueryBuilder.OrderBy field) {
        String orderByString;
        if (field == null) {
            throw new IllegalArgumentException("A null order by criteria is invalid.");
        }
        switch (field) {
            case taskId: {
                orderByString = QueryParameterIdentifiers.TASK_ID_LIST;
                break;
            }
            case processInstanceId: {
                orderByString = QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST;
                break;
            }
            case taskName: {
                orderByString = QueryParameterIdentifiers.TASK_NAME_LIST;
                break;
            }
            case taskStatus: {
                orderByString = QueryParameterIdentifiers.TASK_STATUS_LIST;
                break;
            }
            case createdOn: {
                orderByString = QueryParameterIdentifiers.CREATED_ON_LIST;
                break;
            }
            case createdBy: {
                orderByString = QueryParameterIdentifiers.CREATED_BY_LIST;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported order by arqument: " + field.toString());
            }
        }
        return orderByString;
    }

    public ParametrizedQuery<TaskSummary> build() {
        return new ParametrizedQuery<TaskSummary>(){
            private QueryWhere queryWhere;
            {
                this.queryWhere = new QueryWhere(TaskSummaryQueryBuilderImpl.this.getQueryWhere());
            }

            public List<TaskSummary> getResultList() {
                TaskSummaryQueryCommand cmd = new TaskSummaryQueryCommand(this.queryWhere);
                cmd.setUserId(TaskSummaryQueryBuilderImpl.this.userId);
                return (List)TaskSummaryQueryBuilderImpl.this.executor.execute((Command)cmd);
            }
        };
    }
}

