/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.services;

import java.util.List;
import java.util.ServiceLoader;
import javax.persistence.EntityManagerFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.AdvanceRuntimeDataService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.services.api.utils.KieServiceConfigurator;
import org.jbpm.test.services.AbstractServicesTest;
import org.jbpm.test.services.TestIdentityProvider;
import org.jbpm.test.services.TestUserGroupCallbackImpl;
import org.junit.After;
import org.junit.Before;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;

public abstract class AbstractKieServicesTest
extends AbstractServicesTest {
    protected EntityManagerFactory emf;
    protected DefinitionService bpmn2Service;
    protected RuntimeDataService runtimeDataService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected QueryService queryService;
    protected ProcessInstanceAdminService processAdminService;
    protected AdvanceRuntimeDataService advanceVariableDataService;
    protected TestIdentityProvider identityProvider;
    protected TestUserGroupCallbackImpl userGroupCallback;
    protected KieServiceConfigurator serviceConfigurator;
    protected DeploymentUnit deploymentUnit;

    public AbstractKieServicesTest() {
        this.loadServiceConfigurator();
    }

    protected void loadServiceConfigurator() {
        this.serviceConfigurator = ServiceLoader.load(KieServiceConfigurator.class).iterator().next();
    }

    @Before
    public void setUp() throws Exception {
        this.prepareDocumentStorage();
        this.configureServices();
        this.deploymentUnit = this.prepareDeploymentUnit();
    }

    @After
    public void tearDown() {
        this.clearDocumentStorageProperty();
        if (this.identityProvider != null) {
            this.identityProvider.reset();
        }
        AbstractKieServicesTest.cleanupSingletonSessionId();
        if (this.deploymentUnit != null) {
            this.deploymentService.undeploy(this.deploymentUnit);
            this.deploymentUnit = null;
        }
        this.close();
        ServiceRegistry.get().clear();
    }

    @Override
    protected void close() {
        if (this.serviceConfigurator != null) {
            this.serviceConfigurator.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.closeDataSource();
    }

    protected void configureServices() {
        this.buildDatasource();
        this.identityProvider = new TestIdentityProvider();
        this.userGroupCallback = new TestUserGroupCallbackImpl();
        this.serviceConfigurator.configureServices("org.jbpm.domain", (IdentityProvider)this.identityProvider, (UserGroupCallback)this.userGroupCallback);
        this.bpmn2Service = this.serviceConfigurator.getBpmn2Service();
        this.queryService = this.serviceConfigurator.getQueryService();
        this.deploymentService = this.serviceConfigurator.getDeploymentService();
        this.runtimeDataService = this.serviceConfigurator.getRuntimeDataService();
        this.processService = this.serviceConfigurator.getProcessService();
        this.userTaskService = this.serviceConfigurator.getUserTaskService();
        this.processAdminService = this.serviceConfigurator.getProcessAdminService();
        this.advanceVariableDataService = this.serviceConfigurator.getAdvanceVariableDataService();
    }

    @Override
    protected DeploymentUnit createDeploymentUnit(String groupId, String artifactid, String version) throws Exception {
        return this.serviceConfigurator.createDeploymentUnit(groupId, artifactid, version);
    }

    @Override
    protected DeploymentDescriptor createDeploymentDescriptor() {
        if (this.createDescriptor()) {
            DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
            DeploymentDescriptorBuilder ddBuilder = customDescriptor.getBuilder();
            for (ObjectModel objectModel : this.getProcessListeners()) {
                ddBuilder.addEventListener(objectModel);
            }
            for (ObjectModel objectModel : this.getTaskListeners()) {
                ddBuilder.addTaskEventListener(objectModel);
            }
            for (NamedObjectModel namedObjectModel : this.getWorkItemHandlers()) {
                ddBuilder.addWorkItemHandler(namedObjectModel);
            }
            return customDescriptor;
        }
        return null;
    }

    protected boolean createDescriptor() {
        return false;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    public void setIdentityProvider(TestIdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setUserGroupCallback(TestUserGroupCallbackImpl userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    @Override
    protected abstract List<String> getProcessDefinitionFiles();
}

