/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.JdbcUtils;
import org.h2.util.New;

public class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource {
    private final JdbcDataSourceFactory factory;
    private JdbcConnection physicalConn;
    private volatile Connection handleConn;
    private final ArrayList<ConnectionEventListener> listeners = New.arrayList();
    private Xid currentTransaction;
    private boolean prepared;

    JdbcXAConnection(JdbcDataSourceFactory jdbcDataSourceFactory, int n, JdbcConnection jdbcConnection) {
        this.factory = jdbcDataSourceFactory;
        this.setTrace(jdbcDataSourceFactory.getTrace(), 13, n);
        this.physicalConn = jdbcConnection;
    }

    @Override
    public XAResource getXAResource() {
        this.debugCodeCall("getXAResource");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        this.debugCodeCall("close");
        Connection connection = this.handleConn;
        if (connection != null) {
            this.listeners.clear();
            connection.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        Connection connection = this.handleConn;
        if (connection != null) {
            connection.close();
        }
        this.physicalConn.rollback();
        this.handleConn = new PooledJdbcConnection(this.physicalConn);
        return this.handleConn;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("addConnectionEventListener(listener);");
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("removeConnectionEventListener(listener);");
        this.listeners.remove(connectionEventListener);
    }

    void closedHandle() {
        this.debugCode("closedHandle();");
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ConnectionEventListener connectionEventListener = this.listeners.get(i);
            connectionEventListener.connectionClosed(connectionEvent);
        }
        this.handleConn = null;
    }

    @Override
    public int getTransactionTimeout() {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int n) {
        this.debugCodeCall("setTransactionTimeout", n);
        return false;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) {
        this.debugCode("isSameRM(xares);");
        return xAResource == this;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        this.debugCodeCall("recover", JdbcXAConnection.quoteFlags(n));
        this.checkOpen();
        Statement statement = null;
        try {
            Xid[] xidArray;
            statement = this.physicalConn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION");
            ArrayList<Xid> arrayList = New.arrayList();
            while (resultSet.next()) {
                xidArray = resultSet.getString("TRANSACTION");
                int n2 = JdbcXAConnection.getNextId(15);
                JdbcXid jdbcXid = new JdbcXid(this.factory, n2, (String)xidArray);
                arrayList.add(jdbcXid);
            }
            resultSet.close();
            xidArray = new Xid[arrayList.size()];
            arrayList.toArray(xidArray);
            if (arrayList.size() > 0) {
                this.prepared = true;
            }
            Xid[] xidArray2 = xidArray;
            return xidArray2;
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(-3);
            xAException.initCause(sQLException);
            throw xAException;
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("prepare(" + JdbcXid.toString(xid) + ");");
        }
        this.checkOpen();
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-5);
        }
        Statement statement = null;
        try {
            statement = this.physicalConn.createStatement();
            statement.execute("PREPARE COMMIT " + JdbcXid.toString(xid));
            this.prepared = true;
        }
        catch (SQLException sQLException) {
            throw JdbcXAConnection.convertException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        return 0;
    }

    @Override
    public void forget(Xid xid) {
        if (this.isDebugEnabled()) {
            this.debugCode("forget(" + JdbcXid.toString(xid) + ");");
        }
        this.prepared = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block6: {
            if (this.isDebugEnabled()) {
                this.debugCode("rollback(" + JdbcXid.toString(xid) + ");");
            }
            try {
                this.physicalConn.rollback();
                this.physicalConn.setAutoCommit(true);
                if (!this.prepared) break block6;
                Statement statement = null;
                try {
                    statement = this.physicalConn.createStatement();
                    statement.execute("ROLLBACK TRANSACTION " + JdbcXid.toString(xid));
                }
                finally {
                    JdbcUtils.closeSilently(statement);
                }
                this.prepared = false;
            }
            catch (SQLException sQLException) {
                throw JdbcXAConnection.convertException(sQLException);
            }
        }
        this.currentTransaction = null;
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("end(" + JdbcXid.toString(xid) + ", " + JdbcXAConnection.quoteFlags(n) + ");");
        }
        if (n == 0x2000000) {
            return;
        }
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-9);
        }
        this.prepared = false;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("start(" + JdbcXid.toString(xid) + ", " + JdbcXAConnection.quoteFlags(n) + ");");
        }
        if (n == 0x8000000) {
            return;
        }
        if (n == 0x200000) {
            if (this.currentTransaction != null && !this.currentTransaction.equals(xid)) {
                throw new XAException(-3);
            }
        } else if (this.currentTransaction != null) {
            throw new XAException(-4);
        }
        try {
            this.physicalConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw JdbcXAConnection.convertException(sQLException);
        }
        this.currentTransaction = xid;
        this.prepared = false;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("commit(" + JdbcXid.toString(xid) + ", " + bl + ");");
        }
        Statement statement = null;
        try {
            if (bl) {
                this.physicalConn.commit();
            } else {
                statement = this.physicalConn.createStatement();
                statement.execute("COMMIT TRANSACTION " + JdbcXid.toString(xid));
                this.prepared = false;
            }
            this.physicalConn.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            try {
                throw JdbcXAConnection.convertException(sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(statement);
        this.currentTransaction = null;
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.physicalConn;
    }

    private static XAException convertException(SQLException sQLException) {
        XAException xAException = new XAException(sQLException.getMessage());
        xAException.initCause(sQLException);
        return xAException;
    }

    private static String quoteFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x800000) != 0) {
            stringBuilder.append("|XAResource.TMENDRSCAN");
        }
        if ((n & 0x20000000) != 0) {
            stringBuilder.append("|XAResource.TMFAIL");
        }
        if ((n & 0x200000) != 0) {
            stringBuilder.append("|XAResource.TMJOIN");
        }
        if ((n & 0x40000000) != 0) {
            stringBuilder.append("|XAResource.TMONEPHASE");
        }
        if ((n & 0x8000000) != 0) {
            stringBuilder.append("|XAResource.TMRESUME");
        }
        if ((n & 0x1000000) != 0) {
            stringBuilder.append("|XAResource.TMSTARTRSCAN");
        }
        if ((n & 0x4000000) != 0) {
            stringBuilder.append("|XAResource.TMSUCCESS");
        }
        if ((n & 0x2000000) != 0) {
            stringBuilder.append("|XAResource.TMSUSPEND");
        }
        if ((n & 3) != 0) {
            stringBuilder.append("|XAResource.XA_RDONLY");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("|XAResource.TMNOFLAGS");
        }
        return stringBuilder.toString().substring(1);
    }

    private void checkOpen() throws XAException {
        if (this.physicalConn == null) {
            throw new XAException(-3);
        }
    }

    static {
        Driver.load();
    }

    class PooledJdbcConnection
    extends JdbcConnection {
        private boolean isClosed;

        public PooledJdbcConnection(JdbcConnection jdbcConnection) {
            super(jdbcConnection);
        }

        @Override
        public synchronized void close() throws SQLException {
            if (!this.isClosed) {
                try {
                    this.rollback();
                    this.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                JdbcXAConnection.this.closedHandle();
                this.isClosed = true;
            }
        }

        @Override
        public synchronized boolean isClosed() throws SQLException {
            return this.isClosed || super.isClosed();
        }

        @Override
        protected synchronized void checkClosed(boolean bl) {
            if (this.isClosed) {
                throw DbException.get(90007);
            }
            super.checkClosed(bl);
        }
    }
}

