/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidInfo;
import org.stringtemplate.v4.ST;

@SupportedAnnotationTypes(value={"org.jbpm.process.workitem.core.util.Wid"})
public class WidProcessor
extends AbstractProcessor {
    private Map<String, List<Wid>> processingResults;
    private boolean resetResults = true;
    private static final String WID_ST_TEMPLATE = "[\n$widInfo:{k|\n[\n    \"name\" : \"$widInfo.(k).name$\",\n    \"displayName\" : \"$widInfo.(k).displayName$\",\n    \"category\" : \"$widInfo.(k).category$\",\n    \"description\" : \"$widInfo.(k).description$\",\n    \"defaultHandler\" : \"$widInfo.(k).defaultHandler$\",\n\n    $if(widInfo.(k).parameters)$\n    \"parameters\" : [\n        $widInfo.(k).parameters:{k1|\n            \"$k1$\" : new $widInfo.(k).parameters.(k1).type$()\n        }; separator=\",\"$\n    ],\n    $endif$\n    $if(widInfo.(k).results)$\n    \"results\" : [\n        $widInfo.(k).results:{k1|\n            \"$k1$\" : new $widInfo.(k).results.(k1).type$()\n        }; separator=\",\"$\n    ],\n    $endif$\n    $if(widInfo.(k).mavenDepends)$\n    \"mavenDependencies\" : [\n        $widInfo.(k).mavenDepends:{k1|\n             \"$widInfo.(k).mavenDepends.(k1).group$:$widInfo.(k).mavenDepends.(k1).artifact$:$widInfo.(k).mavenDepends.(k1).version$\"\n        }; separator=\",\"$\n    ],\n    $endif$\n    \"icon\" : \"$widInfo.(k).icon$\"\n\n]\n}; separator=\",\"$\n]";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.resetResults) {
            this.processingResults = new HashMap<String, List<Wid>>();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Wid.class)) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, MessageFormat.format("Wid Processor : processing class {0}.", typeElement.asType().toString()));
            this.processingResults.put(typeElement.asType().toString(), new ArrayList());
            if (typeElement.getInterfaces() != null && typeElement.getInterfaces().size() > 0) {
                for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                    if (typeMirror.getAnnotation(Wid.class) == null) continue;
                    this.processingResults.get(typeElement.asType().toString()).add(typeMirror.getAnnotation(Wid.class));
                }
            }
            this.processingResults.get(typeElement.asType().toString()).add(typeElement.getAnnotation(Wid.class));
        }
        return this.postProcessWorkItemDefinition();
    }

    public boolean postProcessWorkItemDefinition() {
        if (this.processingResults == null || this.processingResults.size() < 1) {
            return false;
        }
        try {
            ST widTemplate = new ST(WID_ST_TEMPLATE, '$', '$');
            HashMap<String, WidInfo> wrappedResults = new HashMap<String, WidInfo>();
            for (String key : this.processingResults.keySet()) {
                wrappedResults.put(key, new WidInfo(this.processingResults.get(key)));
            }
            widTemplate.add("widInfo", wrappedResults);
            String widName = "WorkDefinitions.wid";
            if (this.processingEnv.getOptions().containsKey("widName")) {
                widName = this.processingEnv.getOptions().get("widName");
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Unable to find option \"widName\", using default.");
            }
            FileObject widFile = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", widName, new Element[0]);
            OutputStream stream = widFile.openOutputStream();
            stream.write(widTemplate.render().getBytes());
            stream.close();
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, MessageFormat.format("Error post-processing workitem annotations: {0}.", e.getMessage()));
        }
        return true;
    }

    public void setResetResults(boolean resetResults) {
        this.resetResults = resetResults;
    }

    public Map<String, List<Wid>> getProcessingResults() {
        return this.processingResults;
    }

    public void setProcessingResults(Map<String, List<Wid>> processingResults) {
        this.processingResults = processingResults;
    }
}

