/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.List;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentIdsPreprocessor
implements DataSetPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentIdsPreprocessor.class);
    private DeploymentRolesManager deploymentRolesManager;
    private IdentityProvider identityProvider;
    private String columnId;

    public DeploymentIdsPreprocessor(DeploymentRolesManager deploymentRolesManager, IdentityProvider identityProvider, String columnId) {
        this.deploymentRolesManager = deploymentRolesManager;
        this.identityProvider = identityProvider;
        this.columnId = columnId;
    }

    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null) {
            return;
        }
        List<String> deploymentIds = this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider);
        ColumnFilter columnFilter = FilterFactory.in((String)this.columnId, deploymentIds);
        LOGGER.debug("Adding column filter: {}", (Object)columnFilter);
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            lookup.addOperation(new DataSetOp[]{filter});
        }
    }
}

