/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.PersistentWorkItem;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.NonTransactionalPersistentSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualTransactionManager
implements TransactionManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private NonTransactionalPersistentSession session;
    private KnowledgeSessionStorage storage;
    private TransactionSynchronization transactionSynchronization;
    private static final ThreadLocal<Map<Object, Object>> transactionResources = new ThreadLocal<Map<Object, Object>>(){

        @Override
        protected Map<Object, Object> initialValue() {
            return Collections.synchronizedMap(new HashMap());
        }
    };

    public ManualTransactionManager(NonTransactionalPersistentSession session, KnowledgeSessionStorage storage) {
        this.session = session;
        this.storage = storage;
    }

    public int getStatus() {
        return 0;
    }

    public boolean begin() {
        return true;
    }

    public void commit(boolean transactionOwner) {
        try {
            for (PersistentSession session : this.session.getStoredKnowledgeSessions()) {
                session.transform();
                this.storage.saveOrUpdate(session);
            }
            for (PersistentWorkItem workItem : this.session.getStoredWorkItems()) {
                workItem.transform();
                this.storage.saveOrUpdate(workItem);
            }
            try {
                this.transactionSynchronization.afterCompletion(0);
            }
            catch (RuntimeException re) {
                this.logger.warn("Unable to synchronize transaction after commit, see cause.", (Throwable)re);
            }
        }
        catch (RuntimeException re) {
            this.transactionSynchronization.afterCompletion(1);
        }
    }

    public void rollback(boolean transactionOwner) {
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        this.transactionSynchronization = ts;
    }

    public void putResource(Object key, Object resource) {
        transactionResources.get().put(key, resource);
    }

    public Object getResource(Object key) {
        return transactionResources.get().get(key);
    }
}

