/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error;

import java.util.List;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorContext;
import org.kie.internal.runtime.error.ExecutionErrorFilter;
import org.kie.internal.runtime.error.ExecutionErrorHandler;
import org.kie.internal.runtime.error.ExecutionErrorStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionErrorHandlerImpl
implements ExecutionErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionErrorHandlerImpl.class);
    private List<ExecutionErrorFilter> filters;
    private ExecutionErrorStorage storage;
    private NodeInstance firstExecutedNode;
    private NodeInstance lastExecutedNode;
    private Task lastExecutedTask;

    public ExecutionErrorHandlerImpl(List<ExecutionErrorFilter> filters, ExecutionErrorStorage storage) {
        this.filters = filters;
        this.storage = storage;
    }

    public void processing(NodeInstance nodeInstance) {
        if (this.firstExecutedNode == null) {
            this.firstExecutedNode = nodeInstance;
        }
        logger.debug("Node instance {} is being executed", (Object)nodeInstance);
        this.lastExecutedNode = nodeInstance;
    }

    public void processing(Task task) {
        logger.debug("Task instance {} is being executed", (Object)task);
        this.lastExecutedTask = task;
    }

    public void processed(NodeInstance nodeInstance) {
        if (this.firstExecutedNode == null) {
            this.firstExecutedNode = nodeInstance;
        }
        logger.debug("Node instance {} successfully executed", (Object)nodeInstance);
    }

    public void processed(Task task) {
        logger.debug("Task instance {} successfully executed", (Object)task);
    }

    public void handle(Throwable cause) {
        ExecutionErrorContext errorContext = new ExecutionErrorContext(cause, this.lastExecutedNode, this.lastExecutedTask, this.firstExecutedNode);
        for (ExecutionErrorFilter filter : this.filters) {
            if (!filter.accept(errorContext)) continue;
            ExecutionError error = filter.filter(errorContext);
            logger.debug("Filter {} returned {} for {}", new Object[]{filter, error, cause});
            if (error != null) {
                this.storage.store(error);
                logger.debug("Error event {} stored successfully in {}", (Object)error, (Object)this.storage);
            } else {
                logger.debug("Filter {} accepted error {} but didn't produce results (error should be ignored)", (Object)filter, (Object)cause);
            }
            return;
        }
        logger.error("Unexpected error during processing ", cause);
    }
}

