/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.persistence;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.services.api.query.model.QueryDefinition;

@Entity
@Table(name="QueryDefinitionStore", uniqueConstraints={@UniqueConstraint(columnNames={"qName"})})
@SequenceGenerator(name="queryDefIdSeq", sequenceName="QUERY_DEF_ID_SEQ", allocationSize=1)
public class QueryDefinitionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="queryDefIdSeq")
    @Column(name="id")
    private Long id;
    @Lob
    @Column(name="qExpression", length=65535)
    private String expression;
    @Column(name="qName")
    private String name;
    @Column(name="qSource")
    private String source;
    @Column(name="qTarget")
    private String target;

    public QueryDefinitionEntity() {
    }

    public QueryDefinitionEntity(QueryDefinition queryDefinition) {
        this.name = queryDefinition.getName();
        this.source = queryDefinition.getSource();
        this.expression = queryDefinition.getExpression();
        this.target = queryDefinition.getTarget().toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String toString() {
        return "QueryDefinitionEntity [id=" + this.id + ", name=" + this.name + ", source=" + this.source + ", target=" + this.target + ", {expression=" + this.expression + "}]";
    }

    public QueryDefinition toQueryDefinition() {
        SqlQueryDefinition queryDefinition = new SqlQueryDefinition(this.name, this.source);
        queryDefinition.setExpression(this.expression);
        queryDefinition.setTarget(QueryDefinition.Target.valueOf((String)this.target));
        return queryDefinition;
    }
}

