/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.time.TimerService;
import org.drools.persistence.api.TransactionSynchronization;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineInitlializer;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;

public class PerRequestRuntimeManager
extends AbstractRuntimeManager {
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Map<String, RuntimeEngine>> local = new ThreadLocal<Map<String, RuntimeEngine>>(){

        @Override
        protected Map<String, RuntimeEngine> initialValue() {
            return new HashMap<String, RuntimeEngine>();
        }
    };

    public PerRequestRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.registry.register((RuntimeManager)this);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        RuntimeEngineImpl runtime = null;
        if (local.get().get(this.identifier) != null) {
            RuntimeEngine engine = local.get().get(this.identifier);
            if (engine != null && ((RuntimeEngineImpl)engine).isDisposed()) {
                return null;
            }
            return engine;
        }
        if (this.engineInitEager) {
            InternalTaskService internalTaskService = this.newTaskService(this.taskServiceFactory);
            runtime = new RuntimeEngineImpl(this.factory.newKieSession(), (TaskService)internalTaskService);
            runtime.setManager((RuntimeManager)this);
            this.configureRuntimeOnTaskService(internalTaskService, (RuntimeEngine)runtime);
            this.registerDisposeCallback((RuntimeEngine)runtime, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)this, (RuntimeEngine)runtime), runtime.getKieSession().getEnvironment());
            this.registerDisposeCallback((RuntimeEngine)runtime, (TransactionSynchronization)new DestroySessionTransactionSynchronization(runtime.getKieSession()), runtime.getKieSession().getEnvironment());
            this.registerItems((RuntimeEngine)runtime);
            this.attachManager((RuntimeEngine)runtime);
        } else {
            runtime = new RuntimeEngineImpl(context, new PerRequestInitializer());
            runtime.setManager((RuntimeManager)this);
        }
        local.get().put(this.identifier, (RuntimeEngine)runtime);
        return runtime;
    }

    public void signalEvent(String type, Object event) {
        RuntimeEngine runtimeEngine = this.getRuntimeEngine(EmptyContext.get());
        runtimeEngine.getKieSession().signalEvent(type, event);
        if (this.canDispose(runtimeEngine)) {
            this.disposeRuntimeEngine(runtimeEngine);
        }
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        RuntimeEngine runtimeInUse = local.get().get(this.identifier);
        if (runtimeInUse == null || ((RuntimeEngineImpl)runtimeInUse).getKieSessionId().longValue() != ksession.getIdentifier()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        block10: {
            if (this.isClosed()) {
                throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
            }
            try {
                if (!this.canDispose(runtime)) break block10;
                local.get().remove(this.identifier);
                try {
                    TimerService timerService;
                    Long ksessionId = ((RuntimeEngineImpl)runtime).getKieSessionId();
                    this.factory.onDispose(ksessionId);
                    if (this.canDestroy(runtime)) {
                        runtime.getKieSession().destroy();
                    } else if (runtime instanceof Disposable) {
                        ((Disposable)runtime).dispose();
                    }
                    if (ksessionId != null && (timerService = TimerServiceRegistry.getInstance().get(this.getIdentifier() + "-timerServiceId")) != null && timerService instanceof GlobalTimerService) {
                        ((GlobalTimerService)timerService).clearTimerJobInstances(ksessionId.longValue());
                    }
                }
                catch (Exception e) {
                    if (runtime instanceof Disposable) {
                        ((Disposable)runtime).dispose();
                    }
                }
            }
            catch (Exception e) {
                local.get().remove(this.identifier);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void softDispose(RuntimeEngine runtimeEngine) {
        super.softDispose(runtimeEngine);
        local.get().remove(this.identifier);
    }

    @Override
    public void close() {
        try {
            if (!(this.taskServiceFactory instanceof LocalTaskServiceFactory)) {
                this.removeRuntimeFromTaskService();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this.factory.close();
    }

    @Override
    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    @Override
    public void init() {
        TaskContentRegistry.get().addMarshallerContext(this.getIdentifier(), new ContentMarshallerContext(this.environment.getEnvironment(), this.environment.getClassLoader()));
        this.configureRuntimeOnTaskService(this.newTaskService(this.taskServiceFactory), null);
    }

    private class PerRequestInitializer
    implements RuntimeEngineInitlializer {
        private PerRequestInitializer() {
        }

        @Override
        public KieSession initKieSession(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            RuntimeEngine inUse = (RuntimeEngine)((Map)local.get()).get(PerRequestRuntimeManager.this.identifier);
            if (inUse != null && ((RuntimeEngineImpl)inUse).getKieSessionId() != null) {
                return inUse.getKieSession();
            }
            KieSession ksession = PerRequestRuntimeManager.this.factory.newKieSession();
            ((RuntimeEngineImpl)engine).internalSetKieSession(ksession);
            PerRequestRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)manager, engine), ksession.getEnvironment());
            PerRequestRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DestroySessionTransactionSynchronization(ksession), ksession.getEnvironment());
            PerRequestRuntimeManager.this.registerItems(engine);
            PerRequestRuntimeManager.this.attachManager(engine);
            return ksession;
        }

        @Override
        public TaskService initTaskService(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            InternalTaskService internalTaskService = PerRequestRuntimeManager.this.newTaskService(PerRequestRuntimeManager.this.taskServiceFactory);
            PerRequestRuntimeManager.this.configureRuntimeOnTaskService(internalTaskService, engine);
            return internalTaskService;
        }
    }
}

