/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.drools.core.util.StringUtils;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.CannotAddTaskException;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Email;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalAttachment;
import org.kie.internal.task.api.model.InternalComment;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlTransient
@XmlRootElement(name="user-group-callback-task-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class UserGroupCallbackTaskCommand<T>
extends TaskCommand<T> {
    private static final long serialVersionUID = 2675686383800457244L;
    private static final Logger logger = LoggerFactory.getLogger(UserGroupCallbackTaskCommand.class);
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();
    private static Set<String> restrictedGroups = new HashSet<String>();

    protected List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds, TaskContext context) {
        groupIds = this.doCallbackGroupsOperation(userId, groupIds, context);
        return this.filterGroups(groupIds);
    }

    protected boolean doCallbackUserOperation(String userId, TaskContext context) {
        return this.doCallbackUserOperation(userId, context, false);
    }

    protected boolean doCallbackEmailOperation(String emailId, TaskContext context) {
        if (emailId != null) {
            this.addEmailFromCallbackOperation(emailId, context);
            return true;
        }
        return false;
    }

    protected boolean doCallbackUserOperation(String userId, TaskContext context, boolean throwExceptionWhenNotFound) {
        if (userId != null && context.getUserGroupCallback().existsUser(userId)) {
            this.addUserFromCallbackOperation(userId, context);
            return true;
        }
        if (throwExceptionWhenNotFound) {
            throw new IllegalArgumentException("User " + userId + " was not found in callback " + context.getUserGroupCallback());
        }
        return false;
    }

    protected User doCallbackAndReturnUserOperation(String userId, TaskContext context) {
        if (userId != null && context.getUserGroupCallback().existsUser(userId)) {
            return this.addUserFromCallbackOperation(userId, context);
        }
        return null;
    }

    protected boolean doCallbackGroupOperation(String groupId, TaskContext context) {
        if (groupId != null && context.getUserGroupCallback().existsGroup(groupId) && !restrictedGroups.contains(groupId)) {
            this.addGroupFromCallbackOperation(groupId, context);
            return true;
        }
        return false;
    }

    protected User addUserFromCallbackOperation(String userId, TaskContext context) {
        boolean userExists;
        User user = context.getPersistenceContext().findUser(userId);
        boolean bl = userExists = user != null;
        if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
            user = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)user).setId(userId);
            this.persistIfNotExists((OrganizationalEntity)user, context);
        }
        return user;
    }

    protected void addEmailFromCallbackOperation(String emailId, TaskContext context) {
        boolean emailExists;
        Email email = context.getPersistenceContext().findEmail(emailId);
        boolean bl = emailExists = email != null;
        if (!StringUtils.isEmpty((CharSequence)emailId) && !emailExists) {
            this.persistIfNotExists((OrganizationalEntity)TaskModelProvider.getFactory().newEmail(emailId), context);
        }
    }

    protected void persistIfNotExists(OrganizationalEntity entity, TaskContext context) {
        TaskPersistenceContext tpc = context.getPersistenceContext();
        OrganizationalEntity orgEntity = tpc.findOrgEntity(entity.getId());
        if (orgEntity == null || orgEntity instanceof Group && entity instanceof User || orgEntity instanceof User && entity instanceof Group || orgEntity instanceof Email && entity instanceof Email) {
            tpc.persistOrgEntity(entity);
        }
    }

    protected List<String> doCallbackGroupsOperation(String userId, List<String> groupIds, TaskContext context) {
        block6: {
            block4: {
                List<String> userGroups;
                block5: {
                    if (userId == null) break block4;
                    if (groupIds == null || groupIds.size() <= 0) break block5;
                    List<String> userGroups2 = this.filterGroups(context.getUserGroupCallback().getGroupsForUser(userId));
                    for (String groupId : groupIds) {
                        if (!context.getUserGroupCallback().existsGroup(groupId) || userGroups2 == null || !userGroups2.contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId, context);
                    }
                    break block6;
                }
                if (this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = this.filterGroups(context.getUserGroupCallback().getGroupsForUser(userId))) == null || userGroups.size() <= 0) break block6;
                for (String group : userGroups) {
                    this.addGroupFromCallbackOperation(group, context);
                }
                this.userGroupsMap.put(userId, true);
                groupIds = userGroups;
                break block6;
            }
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId, context);
                }
            }
        }
        return groupIds;
    }

    protected void addGroupFromCallbackOperation(String groupId, TaskContext context) {
        boolean groupExists;
        Group group = context.getPersistenceContext().findGroup(groupId);
        boolean bl = groupExists = group != null;
        if (!StringUtils.isEmpty((CharSequence)groupId) && !groupExists) {
            group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(groupId);
            this.persistIfNotExists((OrganizationalEntity)group, context);
        }
    }

    protected void doCallbackOperationForTaskData(InternalTaskData data, TaskContext context) {
        boolean userExists;
        if (data.getActualOwner() != null && !(userExists = this.doCallbackUserOperation(data.getActualOwner().getId(), context))) {
            data.setActualOwner(null);
            data.setStatus(Status.Ready);
        }
        if (data.getCreatedBy() != null && !(userExists = this.doCallbackUserOperation(data.getCreatedBy().getId(), context))) {
            data.setCreatedBy(null);
        }
    }

    protected void doCallbackOperationForPotentialOwners(List<OrganizationalEntity> potentialOwners, TaskContext context) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        for (OrganizationalEntity orgEntity : potentialOwners) {
            boolean groupExists;
            boolean userExists;
            if (orgEntity instanceof User && !(userExists = this.doCallbackUserOperation(orgEntity.getId(), context))) {
                nonExistingEntities.add(orgEntity);
            }
            if (!(orgEntity instanceof Group) || (groupExists = this.doCallbackGroupOperation(orgEntity.getId(), context))) continue;
            nonExistingEntities.add(orgEntity);
        }
        if (!nonExistingEntities.isEmpty()) {
            potentialOwners.removeAll(nonExistingEntities);
        }
    }

    protected void doCallbackOperationForPeopleAssignments(InternalPeopleAssignments assignments, TaskContext context) {
        ArrayList<Object> nonExistingEntities = new ArrayList<Object>();
        if (assignments != null) {
            List stakeholders;
            List recipients;
            List excludedOwners;
            List businessAdmins = assignments.getBusinessAdministrators();
            if (businessAdmins != null) {
                for (Object admin : businessAdmins) {
                    boolean groupExists;
                    boolean userExists;
                    if (admin instanceof User && !(userExists = this.doCallbackUserOperation(admin.getId(), context))) {
                        nonExistingEntities.add(admin);
                    }
                    if (!(admin instanceof Group) || (groupExists = this.doCallbackGroupOperation(admin.getId(), context))) continue;
                    nonExistingEntities.add(admin);
                }
                if (!nonExistingEntities.isEmpty()) {
                    businessAdmins.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (businessAdmins == null || businessAdmins.isEmpty()) {
                throw new CannotAddTaskException("There are no known Business Administrators, task cannot be created according to WS-HT specification");
            }
            List potentialOwners = assignments.getPotentialOwners();
            if (potentialOwners != null) {
                for (OrganizationalEntity powner : potentialOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (powner instanceof User && !(userExists = this.doCallbackUserOperation(powner.getId(), context))) {
                        nonExistingEntities.add(powner);
                    }
                    if (!(powner instanceof Group) || (groupExists = this.doCallbackGroupOperation(powner.getId(), context))) continue;
                    nonExistingEntities.add(powner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    potentialOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (assignments.getTaskInitiator() != null && assignments.getTaskInitiator().getId() != null) {
                this.doCallbackUserOperation(assignments.getTaskInitiator().getId(), context);
            }
            if ((excludedOwners = assignments.getExcludedOwners()) != null) {
                for (OrganizationalEntity exowner : excludedOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (exowner instanceof User && !(userExists = this.doCallbackUserOperation(exowner.getId(), context))) {
                        nonExistingEntities.add(exowner);
                    }
                    if (!(exowner instanceof Group) || (groupExists = this.doCallbackGroupOperation(exowner.getId(), context))) continue;
                    nonExistingEntities.add(exowner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    excludedOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((recipients = assignments.getRecipients()) != null) {
                for (OrganizationalEntity recipient : recipients) {
                    boolean groupExists;
                    boolean userExists;
                    if (recipient instanceof User && !(userExists = this.doCallbackUserOperation(recipient.getId(), context))) {
                        nonExistingEntities.add(recipient);
                    }
                    if (!(recipient instanceof Group) || (groupExists = this.doCallbackGroupOperation(recipient.getId(), context))) continue;
                    nonExistingEntities.add(recipient);
                }
                if (!nonExistingEntities.isEmpty()) {
                    recipients.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((stakeholders = assignments.getTaskStakeholders()) != null) {
                for (OrganizationalEntity stakeholder : stakeholders) {
                    boolean groupExists;
                    boolean userExists;
                    if (stakeholder instanceof User && !(userExists = this.doCallbackUserOperation(stakeholder.getId(), context))) {
                        nonExistingEntities.add(stakeholder);
                    }
                    if (!(stakeholder instanceof Group) || (groupExists = this.doCallbackGroupOperation(stakeholder.getId(), context))) continue;
                    nonExistingEntities.add(stakeholder);
                }
                if (!nonExistingEntities.isEmpty()) {
                    stakeholders.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
        }
    }

    protected void doCallbackOperationForTaskDeadlines(Deadlines deadlines, TaskContext context) {
        if (deadlines != null) {
            if (deadlines.getStartDeadlines() != null) {
                List startDeadlines = deadlines.getStartDeadlines();
                this.doCallbackDeadlines(startDeadlines, context);
            }
            if (deadlines.getEndDeadlines() != null) {
                List endDeadlines = deadlines.getEndDeadlines();
                this.doCallbackDeadlines(endDeadlines, context);
            }
        }
    }

    private void doCallbackDeadlines(List<? extends Deadline> deadlines, TaskContext context) {
        for (Deadline deadline : deadlines) {
            List escalations = deadline.getEscalations();
            if (escalations == null) continue;
            for (Escalation escalation : escalations) {
                List notifications = escalation.getNotifications();
                List ressignments = escalation.getReassignments();
                if (notifications != null) {
                    for (Notification notification : notifications) {
                        List administrators;
                        OrganizationalEntity recipient22;
                        List recipients = notification.getRecipients();
                        if (recipients != null) {
                            for (OrganizationalEntity recipient22 : recipients) {
                                if (recipient22 instanceof User) {
                                    this.doCallbackUserOperation(recipient22.getId(), context);
                                    continue;
                                }
                                if (recipient22 instanceof Group) {
                                    this.doCallbackGroupOperation(recipient22.getId(), context);
                                    continue;
                                }
                                if (!(recipient22 instanceof Email)) continue;
                                this.doCallbackEmailOperation(recipient22.getId(), context);
                            }
                        }
                        if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                        recipient22 = administrators.iterator();
                        while (recipient22.hasNext()) {
                            OrganizationalEntity administrator = (OrganizationalEntity)recipient22.next();
                            if (administrator instanceof User) {
                                this.doCallbackUserOperation(administrator.getId(), context);
                            }
                            if (!(administrator instanceof Group)) continue;
                            this.doCallbackGroupOperation(administrator.getId(), context);
                        }
                    }
                }
                if (ressignments == null) continue;
                for (Reassignment reassignment : ressignments) {
                    List potentialOwners = reassignment.getPotentialOwners();
                    if (potentialOwners == null) continue;
                    for (OrganizationalEntity potentialOwner : potentialOwners) {
                        if (potentialOwner instanceof User) {
                            this.doCallbackUserOperation(potentialOwner.getId(), context);
                        }
                        if (!(potentialOwner instanceof Group)) continue;
                        this.doCallbackGroupOperation(potentialOwner.getId(), context);
                    }
                }
            }
        }
    }

    protected void doCallbackOperationForComment(Comment comment, TaskContext context) {
        User entity;
        if (comment != null && comment.getAddedBy() != null && (entity = this.doCallbackAndReturnUserOperation(comment.getAddedBy().getId(), context)) != null) {
            ((InternalComment)comment).setAddedBy(entity);
        }
    }

    protected void doCallbackOperationForAttachment(Attachment attachment, TaskContext context) {
        User entity;
        if (attachment != null && attachment.getAttachedBy() != null && (entity = this.doCallbackAndReturnUserOperation(attachment.getAttachedBy().getId(), context)) != null) {
            ((InternalAttachment)attachment).setAttachedBy(entity);
        }
    }

    protected List<String> filterGroups(List<String> groups) {
        if (groups != null) {
            groups.removeAll(restrictedGroups);
        } else {
            groups = new ArrayList<String>();
        }
        return groups;
    }

    protected boolean isBusinessAdmin(String userId, List<OrganizationalEntity> businessAdmins, TaskContext context) {
        ArrayList<String> usersGroup = new ArrayList<String>(context.getUserGroupCallback().getGroupsForUser(userId));
        usersGroup.add(userId);
        return businessAdmins.stream().anyMatch(oe -> usersGroup.contains(oe.getId()));
    }

    public T execute(Context context) {
        throw new UnsupportedOperationException("org.jbpm.services.task.commands.UserGroupCallbackTaskCommand.execute -> TODO");
    }

    static {
        try {
            InputStream in = UserGroupCallbackTaskCommand.class.getResourceAsStream("/restricted-groups.properties");
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                restrictedGroups.addAll(props.stringPropertyNames());
            }
        }
        catch (Exception e) {
            logger.warn("Error when loading restricted groups for human task service {}", (Object)e.getMessage());
        }
    }
}

