/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.admin.CaseInstanceMigrationService;
import org.jbpm.casemgmt.api.admin.CaseMigrationReport;
import org.jbpm.casemgmt.impl.command.UpdateCaseFileInstanceCommand;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.admin.MigrationReport;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.CompositeCommand;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceMigrationServiceImpl
implements CaseInstanceMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(CaseInstanceMigrationServiceImpl.class);
    private ProcessService processService;
    private CaseRuntimeDataService caseRuntimeDataService;
    private ProcessInstanceMigrationService processInstanceMigrationService;
    private TransactionalCommandService commandService;

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setCaseRuntimeDataService(CaseRuntimeDataService caseRuntimeDataService) {
        this.caseRuntimeDataService = caseRuntimeDataService;
    }

    public void setProcessInstanceMigrationService(ProcessInstanceMigrationService processInstanceMigrationService) {
        this.processInstanceMigrationService = processInstanceMigrationService;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public CaseMigrationReport migrate(String caseId, String targetDeploymentId, Map<String, String> processMapping) {
        return this.migrate(caseId, targetDeploymentId, processMapping, Collections.emptyMap());
    }

    public CaseMigrationReport migrate(String caseId, String targetDeploymentId, Map<String, String> processMapping, Map<String, String> nodeMapping) {
        Collection caseProcesses = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext("Id", true));
        if (caseProcesses.isEmpty()) {
            throw new CaseNotFoundException("Case " + caseId + " does not exist or is not active, cannot be migrated");
        }
        if (caseProcesses.stream().anyMatch(pi -> !processMapping.containsKey(pi.getProcessId()))) {
            throw new RuntimeException("Not possible to migrate case instance " + caseId + " due to missing process mapping");
        }
        logger.debug("About to migrate {} process instances that are active for case instance {}", (Object)caseProcesses, (Object)caseId);
        CaseMigrationReport report = new CaseMigrationReport();
        ProcessInstanceDesc caseProcessInstance = null;
        String caseDefinitionId = null;
        for (ProcessInstanceDesc processInstance : caseProcesses) {
            String targetProcessId = processMapping.get(processInstance.getProcessId());
            if (processInstance.getCorrelationKey().equals(caseId)) {
                caseProcessInstance = processInstance;
                caseDefinitionId = targetProcessId;
            }
            logger.debug("Migrating process instance {} to {} in deployment {}", new Object[]{processInstance.getId(), targetProcessId, targetDeploymentId});
            MigrationReport individualReport = this.processInstanceMigrationService.migrate(processInstance.getDeploymentId(), processInstance.getId(), targetDeploymentId, targetProcessId, nodeMapping);
            report.addReport(individualReport);
            if (!individualReport.isSuccessful()) {
                logger.debug("Process instance {} failed during migration, aborting (with compensation)", (Object)processInstance.getId());
                break;
            }
            logger.debug("Process instance {} was migrated with status {} as part of case instance {} migration", new Object[]{processInstance.getId(), individualReport.isSuccessful(), caseId});
        }
        report.complete();
        if (report.isSuccessful()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("caseId", caseId);
            parameters.put("owner", targetDeploymentId);
            UpdateStringCommand updateCommand = new UpdateStringCommand("update ContextMappingInfo set ownerId = :owner where contextId = :caseId", parameters);
            HashMap<String, String> parametersLog = new HashMap<String, String>();
            parametersLog.put("caseId", caseId);
            parametersLog.put("caseDefId", caseDefinitionId);
            UpdateStringCommand updateCommandLog = new UpdateStringCommand("update CaseFileDataLog set caseDefId = :caseDefId where caseId = :caseId", parametersLog);
            this.commandService.execute((Command)new CompositeCommand(new ExecutableCommand[]{updateCommand, updateCommandLog}));
            this.processService.execute(targetDeploymentId, (Context)ProcessInstanceIdContext.get((Long)caseProcessInstance.getId()), (Command)new UpdateCaseFileInstanceCommand(caseDefinitionId));
            logger.info("Migration of case instance {} completed successfully - number of migrated process instances {}", (Object)caseId, (Object)report.getReports().size());
        } else {
            logger.info("Migration of case instance {} failed due to some instances were not migrated, reverting to previous version", (Object)caseId);
            Map<String, String> inversedNodeMapping = nodeMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map<Long, ProcessInstanceDesc> instances = this.mapProcessInstances(caseProcesses);
            AtomicInteger revertCounter = new AtomicInteger(0);
            report.getReports().forEach(r -> {
                if (r.isSuccessful()) {
                    ProcessInstanceDesc source = (ProcessInstanceDesc)instances.get(r.getProcessInstanceId());
                    MigrationReport individualReportRevert = this.processInstanceMigrationService.migrate(targetDeploymentId, r.getProcessInstanceId(), source.getDeploymentId(), source.getProcessId(), inversedNodeMapping);
                    if (individualReportRevert.isSuccessful()) {
                        revertCounter.incrementAndGet();
                        logger.info("Reverted process instance migration for {} successfully completed", (Object)individualReportRevert.getProcessInstanceId());
                    } else {
                        logger.info("Reverted process instance migration for {} failed", (Object)individualReportRevert.getProcessInstanceId());
                    }
                }
            });
            logger.info("Revert of migration of case instance {} completed with reverted processes {}", (Object)caseId, (Object)revertCounter.get());
        }
        return report;
    }

    protected Map<Long, ProcessInstanceDesc> mapProcessInstances(Collection<ProcessInstanceDesc> processes) {
        return processes.stream().collect(Collectors.toMap(ProcessInstanceDesc::getId, p -> p));
    }
}

