/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.assignment.AssignmentService;
import org.jbpm.services.task.assignment.AssignmentServiceProvider;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.deadlines.notifications.impl.NotificationListenerManager;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.impl.util.DeadlineSchedulerHelper;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.NotificationEvent;
import org.kie.internal.task.api.model.NotificationType;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="execute-deadlines-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ExecuteDeadlinesCommand
extends TaskCommand<Void> {
    private static final long serialVersionUID = 3140157192156956692L;
    private static final Logger logger = LoggerFactory.getLogger(ExecuteDeadlinesCommand.class);
    @XmlElement
    @XmlSchemaType(name="long")
    private Long deadlineId;
    @XmlElement
    private TaskDeadlinesService.DeadlineType type;

    public ExecuteDeadlinesCommand() {
    }

    public ExecuteDeadlinesCommand(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type) {
        this.taskId = taskId;
        this.deadlineId = deadlineId;
        this.type = type;
    }

    public Void execute(Context context) {
        TaskContext ctx = (TaskContext)context;
        UserInfo userInfo = (UserInfo)context.get("org.kie.api.task.UserInfo");
        TaskPersistenceContext persistenceContext = ctx.getPersistenceContext();
        try {
            Task task = persistenceContext.findTask(this.taskId);
            Deadline deadline = persistenceContext.findDeadline(this.deadlineId);
            if (task == null || deadline == null) {
                return null;
            }
            TaskData taskData = task.getTaskData();
            if (taskData != null && this.type.isValidStatus(taskData.getStatus())) {
                HashMap<String, Object> variables = null;
                Content content = persistenceContext.findContent(Long.valueOf(taskData.getDocumentContentId()));
                if (content != null) {
                    ContentMarshallerContext mContext = ctx.getTaskContentService().getMarshallerContext(task);
                    Object objectFromBytes = ContentMarshallerHelper.unmarshall(content.getContent(), mContext.getEnvironment(), mContext.getClassloader());
                    if (objectFromBytes instanceof Map) {
                        variables = (HashMap<String, Object>)objectFromBytes;
                    } else {
                        variables = new HashMap<String, Object>();
                        variables.put("content", objectFromBytes);
                    }
                } else {
                    variables = Collections.emptyMap();
                }
                if (deadline == null || deadline.getEscalations() == null) {
                    return null;
                }
                TaskEventSupport taskEventSupport = ctx.getTaskEventSupport();
                for (Escalation escalation : deadline.getEscalations()) {
                    if (!escalation.getReassignments().isEmpty()) {
                        taskEventSupport.fireBeforeTaskReassigned(task, ctx);
                        Reassignment reassignment = (Reassignment)escalation.getReassignments().get(0);
                        logger.debug("Reassigning to {}", (Object)reassignment.getPotentialOwners());
                        ((InternalTaskData)task.getTaskData()).setStatus(Status.Ready);
                        ArrayList potentialOwners = new ArrayList(reassignment.getPotentialOwners());
                        ((InternalPeopleAssignments)task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
                        ((InternalTaskData)task.getTaskData()).setActualOwner(null);
                        AssignmentService assignmentService = AssignmentServiceProvider.get();
                        if (assignmentService.isEnabled()) {
                            ctx.loadTaskVariables(task);
                            assignmentService.assignTask(task, (org.kie.api.task.TaskContext)ctx);
                        }
                        taskEventSupport.fireAfterTaskReassigned(task, ctx);
                    }
                    for (Notification notification : escalation.getNotifications()) {
                        if (notification.getNotificationType() != NotificationType.Email) continue;
                        taskEventSupport.fireBeforeTaskNotified(task, ctx);
                        logger.debug("Sending an Email");
                        NotificationListenerManager.get().broadcast(ctx, new NotificationEvent(notification, task, variables), userInfo);
                        taskEventSupport.fireAfterTaskNotified(task, ctx);
                    }
                }
            }
            deadline.setEscalated(Boolean.valueOf(true));
            persistenceContext.updateDeadline(deadline);
            persistenceContext.updateTask(task);
            DeadlineSchedulerHelper.rescheduleDeadlinesForTask((InternalTask)task, ctx, true, this.type);
        }
        catch (Exception e) {
            logger.error("Error when executing deadlines", (Throwable)e);
        }
        return null;
    }
}

