/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;

public class SpatialTreeIndex
extends BaseIndex
implements SpatialIndex {
    private Quadtree root;
    private final RegularTable tableData;
    private long rowCount;
    private boolean closed;

    public SpatialTreeIndex(RegularTable regularTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        if (indexType.isUnique()) {
            throw DbException.getUnsupportedException("not unique");
        }
        if (indexColumnArray.length > 1) {
            throw DbException.getUnsupportedException("can only do one column");
        }
        if ((indexColumnArray[0].sortType & 1) != 0) {
            throw DbException.getUnsupportedException("cannot do descending");
        }
        if ((indexColumnArray[0].sortType & 2) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls first");
        }
        if ((indexColumnArray[0].sortType & 4) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls last");
        }
        this.initBaseIndex(regularTable, n, string, indexColumnArray, indexType);
        this.tableData = regularTable;
        if (!this.database.isStarting() && indexColumnArray[0].column.getType() != 22) {
            throw DbException.getUnsupportedException("spatial index on non-geometry column, " + indexColumnArray[0].column.getCreateSQL());
        }
        this.root = new Quadtree();
    }

    @Override
    public void close(Session session) {
        this.root = null;
        this.closed = true;
    }

    @Override
    public void add(Session session, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        this.root.insert(this.getEnvelope(row), (Object)row);
        ++this.rowCount;
    }

    private Envelope getEnvelope(SearchRow searchRow) {
        Value value = searchRow.getValue(this.columnIds[0]);
        Geometry geometry = ((ValueGeometry)value).getGeometry();
        return geometry.getEnvelopeInternal();
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        if (!this.root.remove(this.getEnvelope(row), (Object)row)) {
            throw DbException.throwInternalError("row not found");
        }
        --this.rowCount;
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find();
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find();
    }

    private Cursor find() {
        List list = this.root.queryAll();
        return new ListCursor(list, true);
    }

    @Override
    public Cursor findByGeometry(TableFilter tableFilter, SearchRow searchRow) {
        List list = searchRow != null ? this.root.query(this.getEnvelope(searchRow)) : this.root.queryAll();
        return new ListCursor(list, true);
    }

    @Override
    public double getCost(Session session, int[] nArray, SortOrder sortOrder) {
        return this.getCostRangeIndex(nArray, this.tableData.getRowCountApproximation(), sortOrder);
    }

    @Override
    public void remove(Session session) {
        this.truncate(session);
    }

    @Override
    public void truncate(Session session) {
        this.root = null;
        this.rowCount = 0L;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        List list = this.root.queryAll();
        return new ListCursor(list, bl);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    private static final class ListCursor
    implements Cursor {
        private final List<Row> rows;
        private int index;
        private Row current;

        public ListCursor(List<Row> list, boolean bl) {
            this.rows = list;
            this.index = bl ? 0 : list.size();
        }

        @Override
        public Row get() {
            return this.current;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.current;
        }

        @Override
        public boolean next() {
            this.current = this.index >= this.rows.size() ? null : this.rows.get(this.index++);
            return this.current != null;
        }

        @Override
        public boolean previous() {
            this.current = this.index < 0 ? null : this.rows.get(this.index--);
            return this.current != null;
        }
    }
}

