/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageBuilderResults;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.rule.TypeDeclaration;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.AssemblerContext;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;

public interface InternalKnowledgeBuilder
extends KnowledgeBuilder,
DroolsAssemblerContext,
AssemblerContext {
    public ResourceRemovalResult removeObjectsGeneratedFromResource(Resource var1);

    public void addPackage(PackageDescr var1);

    public InternalKnowledgePackage getPackage(String var1);

    public void rewireAllClassObjectTypes();

    public static class Empty
    implements InternalKnowledgeBuilder {
        private final ClassLoader rootClassLoader;
        private final Supplier<KnowledgeBuilderImpl> lazyBuilder;
        private KnowledgeBuilderImpl knowledgeBuilder;

        public Empty(ClassLoader rootClassLoader, Supplier<KnowledgeBuilderImpl> lazyBuilder) {
            this.rootClassLoader = rootClassLoader;
            this.lazyBuilder = lazyBuilder;
        }

        private synchronized KnowledgeBuilderImpl getKnowledgeBuilder() {
            if (this.knowledgeBuilder == null) {
                this.knowledgeBuilder = this.lazyBuilder.get();
            }
            return this.knowledgeBuilder;
        }

        public Collection<KiePackage> getKnowledgePackages() {
            return Collections.emptyList();
        }

        public boolean hasErrors() {
            return false;
        }

        @Override
        public KnowledgeBuilderErrors getErrors() {
            return new PackageBuilderErrors();
        }

        public KnowledgeBuilderResults getResults(ResultSeverity ... severities) {
            return new PackageBuilderResults();
        }

        public boolean hasResults(ResultSeverity ... severities) {
            return false;
        }

        @Override
        public ClassLoader getRootClassLoader() {
            return this.rootClassLoader;
        }

        @Override
        public void rewireAllClassObjectTypes() {
        }

        @Override
        public Map<String, Class<?>> getGlobals() {
            return Collections.emptyMap();
        }

        public void add(Resource resource, ResourceType type) {
            this.getKnowledgeBuilder().add(resource, type);
        }

        public void add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
            this.getKnowledgeBuilder().add(resource, type, configuration);
        }

        public KieBase newKieBase() {
            return this.getKnowledgeBuilder().newKieBase();
        }

        public void undo() {
            this.getKnowledgeBuilder().undo();
        }

        public CompositeKnowledgeBuilder batch() {
            return this.getKnowledgeBuilder().batch();
        }

        public <T extends ResourceTypePackage<?>> T computeIfAbsent(ResourceType resourceType, String namespace, Function<? super ResourceType, T> mappingFunction) {
            return this.getKnowledgeBuilder().computeIfAbsent(resourceType, namespace, mappingFunction);
        }

        public void reportError(KnowledgeBuilderError error) {
            this.getKnowledgeBuilder().reportError(error);
        }

        @Override
        public ResourceRemovalResult removeObjectsGeneratedFromResource(Resource resource) {
            return this.getKnowledgeBuilder().removeObjectsGeneratedFromResource(resource);
        }

        @Override
        public void addPackage(PackageDescr packageDescr) {
            this.getKnowledgeBuilder().addPackage(packageDescr);
        }

        @Override
        public InternalKnowledgePackage getPackage(String name) {
            return this.getKnowledgeBuilder().getPackage(name);
        }

        @Override
        public KnowledgeBuilderConfigurationImpl getBuilderConfiguration() {
            return this.getKnowledgeBuilder().getBuilderConfiguration();
        }

        @Override
        public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String name) {
            return this.getKnowledgeBuilder().getAndRegisterTypeDeclaration(cls, name);
        }

        @Override
        public TypeDeclaration getTypeDeclaration(Class<?> typeClass) {
            return this.getKnowledgeBuilder().getTypeDeclaration(typeClass);
        }

        @Override
        public List<PackageDescr> getPackageDescrs(String namespace) {
            return this.getKnowledgeBuilder().getPackageDescrs(namespace);
        }

        @Override
        public PackageRegistry getPackageRegistry(String packageName) {
            return this.getKnowledgeBuilder().getPackageRegistry(packageName);
        }

        @Override
        public InternalKnowledgeBase getKnowledgeBase() {
            return this.getKnowledgeBuilder().getKnowledgeBase();
        }
    }

    public static class ResourceRemovalResult {
        private boolean modified;
        private Collection<String> removedTypes;

        public ResourceRemovalResult() {
            this(false, Collections.emptyList());
        }

        public ResourceRemovalResult(boolean modified, Collection<String> removedTypes) {
            this.modified = modified;
            this.removedTypes = removedTypes;
        }

        public void add(ResourceRemovalResult other) {
            this.mergeModified(other.modified);
            if (this.removedTypes.isEmpty()) {
                this.removedTypes = other.removedTypes;
            } else {
                this.removedTypes.addAll(other.removedTypes);
            }
        }

        public void mergeModified(boolean otherModified) {
            this.modified = this.modified || otherModified;
        }

        public boolean isModified() {
            return this.modified;
        }

        public Collection<String> getRemovedTypes() {
            return this.removedTypes;
        }
    }
}

