/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.util;

import com.arjuna.ats.jta.TransactionManager;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.test.util.db.DataSourceFactory;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    public static final String DROOLS_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa";
    public static final String DROOLS_LOCAL_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa.local";
    public static final String JBPM_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa";
    public static final String JBPM_LOCAL_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa.local";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    public static final String MAX_POOL_SIZE = "maxPoolSize";
    public static final String ALLOW_LOCAL_TXS = "allowLocalTransactions";
    public static final String SERVER_NAME = "serverName";
    public static final String SERVER_PORT = "portNumber";
    public static final String DATABASE_NAME = "databaseName";
    public static final String DATASOURCE_CLASS_NAME = "className";
    public static final String DRIVER_CLASS_NAME = "driverClassName";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String JDBC_URL = "url";
    private static TestH2Server h2Server = new TestH2Server();
    private static Properties defaultProperties = null;
    public static final String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, "jdbc/testDS1");
    }

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName, String dataSourceName) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        PoolingDataSourceWrapper ds1 = PersistenceUtil.setupPoolingDataSource(PersistenceUtil.getDatasourceProperties(), dataSourceName);
        context.put(DATASOURCE, ds1);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        context.put("org.kie.api.persistence.jpa.EntityManagerFactory", emf);
        return context;
    }

    public static void startH2TcpServer(Properties datasourceProperties) {
        String jdbcUrl = datasourceProperties.getProperty(JDBC_URL);
        if (jdbcUrl != null && jdbcUrl.matches("jdbc:h2:tcp:.*")) {
            h2Server.start(datasourceProperties.getProperty("tcpPort"));
        }
    }

    public static void stopH2TcpServer() {
        h2Server.stop();
    }

    public static void cleanUp(Map<String, Object> context) {
        if (context != null) {
            Object ds1Object;
            Object emfObject = context.remove("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emfObject != null) {
                try {
                    EntityManagerFactory emf = (EntityManagerFactory)emfObject;
                    emf.close();
                }
                catch (Throwable t) {
                    logger.error("Unable to close entity manager factory {}", (Object)"org.kie.api.persistence.jpa.EntityManagerFactory", (Object)t);
                }
            }
            if ((ds1Object = context.remove(DATASOURCE)) != null) {
                try {
                    PoolingDataSourceWrapper ds1 = (PoolingDataSourceWrapper)ds1Object;
                    ds1.close();
                }
                catch (Throwable t) {
                    logger.error("Unable to close pooling datasource wrapper {}", (Object)DATASOURCE, (Object)t);
                }
            }
        }
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(Properties dsProps) {
        return PersistenceUtil.setupPoolingDataSource(dsProps, "jdbc/testDS1");
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(Properties dsProps, String datasourceName) {
        PersistenceUtil.startH2TcpServer(dsProps);
        return DataSourceFactory.setupPoolingDataSource((String)datasourceName, (Properties)dsProps);
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{SERVER_NAME, SERVER_PORT, DATABASE_NAME, JDBC_URL, USER, PASSWORD, DRIVER_CLASS_NAME, DATASOURCE_CLASS_NAME, MAX_POOL_SIZE, ALLOW_LOCAL_TXS};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:mem:jbpm-db;MVCC=true", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "16", "true"};
            Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
            defaultProperties = new Properties();
            for (int i = 0; i < keyArr.length; ++i) {
                defaultProperties.put(keyArr[i], defaultPropArr[i]);
            }
        }
        return defaultProperties;
    }

    public static Properties getDatasourceProperties() {
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        Properties props = new Properties();
        try (InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);){
            Assert.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
            props.load(propsInputStream);
        }
        catch (IOException ioe) {
            propertiesNotFound = true;
            logger.warn("Unable to find properties, using default H2 properties: {}", (Object)ioe.getMessage());
            logger.warn("Stacktrace:", (Throwable)ioe);
        }
        String password = props.getProperty(PASSWORD);
        if ("${maven.jdbc.password}".equals(password) || propertiesNotFound) {
            props = PersistenceUtil.getDefaultProperties();
        }
        return props;
    }

    public static boolean useTransactions() {
        boolean useTransactions = false;
        String databaseDriverClassName = PersistenceUtil.getDatasourceProperties().getProperty(DRIVER_CLASS_NAME);
        if (databaseDriverClassName.startsWith("org.postgresql") || databaseDriverClassName.startsWith("com.edb")) {
            useTransactions = true;
        }
        return useTransactions;
    }

    public static Environment createEnvironment(Map<String, Object> context) {
        Environment env = EnvironmentFactory.newEnvironment();
        UserTransaction ut = (UserTransaction)context.get("org.kie.transaction.Transaction");
        if (ut != null) {
            env.set("org.kie.transaction.Transaction", (Object)ut);
        }
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManager.transactionManager());
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        return env;
    }

    public static KieSession createKieSessionFromKBase(KieBase kbase, Map<String, Object> context) {
        Properties defaultProps = new Properties();
        defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)defaultProps);
        ksconf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        return kbase.newKieSession(ksconf, PersistenceUtil.createEnvironment(context));
    }

    private static class TestH2Server {
        private Server realH2Server;

        private TestH2Server() {
        }

        public synchronized void start(String port) {
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    String[] stringArray;
                    DeleteDbFiles.execute((String)"", null, (boolean)true);
                    if (port != null && !port.isEmpty()) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "-tcpPort";
                        stringArray = stringArray2;
                        stringArray2[1] = port;
                    } else {
                        stringArray = new String[]{};
                    }
                    this.realH2Server = Server.createTcpServer((String[])stringArray);
                    this.realH2Server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("can't start h2 server db", e);
                }
            }
        }

        protected void finalize() throws Throwable {
            this.stop();
            super.finalize();
        }

        public synchronized void stop() {
            if (this.realH2Server != null) {
                this.realH2Server.stop();
                this.realH2Server.shutdown();
                DeleteDbFiles.execute((String)"", null, (boolean)true);
                this.realH2Server = null;
            }
        }
    }
}

