/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.naming.directory.SearchResult;
import org.jbpm.services.task.identity.AbstractLDAPUserGroupInfo;
import org.kie.api.task.UserGroupCallback;

public class LDAPUserGroupCallbackImpl
extends AbstractLDAPUserGroupInfo
implements UserGroupCallback {
    private static final String DEFAULT_PROPERTIES_NAME = "jbpm.usergroup.callback";
    public static final String USER_CTX = "ldap.user.ctx";
    public static final String ROLE_CTX = "ldap.role.ctx";
    public static final String USER_ROLES_CTX = "ldap.user.roles.ctx";
    public static final String USER_FILTER = "ldap.user.filter";
    public static final String ROLE_FILTER = "ldap.role.filter";
    public static final String USER_ROLES_FILTER = "ldap.user.roles.filter";
    public static final String USER_ATTR_ID = "ldap.user.attr.id";
    public static final String ROLE_ATTR_ID = "ldap.roles.attr.id";
    public static final String IS_USER_ID_DN = "ldap.user.id.dn";
    public static final String SEARCH_SCOPE = "ldap.search.scope";
    public static final String LDAP_NAME_ESCAPE = "ldap.name.escape";
    private static final String[] REQUIRED_PROPERTIES = new String[]{"ldap.user.ctx", "ldap.role.ctx", "ldap.user.filter", "ldap.role.filter", "ldap.user.roles.filter"};
    private static final String DEFAULT_USER_ID_DN = "false";

    public LDAPUserGroupCallbackImpl(boolean activate) {
        super(REQUIRED_PROPERTIES, DEFAULT_PROPERTIES_NAME);
    }

    public LDAPUserGroupCallbackImpl(Properties config) {
        super(REQUIRED_PROPERTIES, config);
    }

    public boolean existsUser(String userId) {
        String context = this.getConfigProperty(USER_CTX);
        String filter = this.getConfigProperty(USER_FILTER);
        String attributeId = this.getConfigProperty(USER_ATTR_ID, "uid");
        return this.existsEntity(userId, context, filter, attributeId);
    }

    public boolean existsGroup(String groupId) {
        String context = this.getConfigProperty(ROLE_CTX);
        String filter = this.getConfigProperty(ROLE_FILTER);
        String attributeId = this.getConfigProperty(ROLE_ATTR_ID, "cn");
        return this.existsEntity(groupId, context, filter, attributeId);
    }

    private boolean existsEntity(String entityId, String context, String filter, String attributeId) {
        entityId = this.escapeIllegalChars(entityId);
        String ldapEntityId = this.ldapSearcher.search(context, filter, entityId).getSingleAttributeResult(attributeId);
        return entityId.equals(ldapEntityId);
    }

    public List<String> getGroupsForUser(String userId) {
        String roleContext = this.getConfigProperty(USER_ROLES_CTX, this.getConfigProperty(ROLE_CTX));
        String roleFilter = this.getConfigProperty(USER_ROLES_FILTER);
        String roleAttributeId = this.getConfigProperty(ROLE_ATTR_ID, "cn");
        String userDn = userId;
        if (!this.isUserIdDn()) {
            String userContext = this.getConfigProperty(USER_CTX);
            String userFilter = this.getConfigProperty(USER_FILTER);
            SearchResult searchResult = this.ldapSearcher.search(userContext, userFilter, userId).getSingleSearchResult();
            userDn = searchResult.getNameInNamespace();
        }
        List<String> result = this.ldapSearcher.search(roleContext, roleFilter, userDn).getAttributeResults(roleAttributeId);
        return result.stream().map(r -> this.unescapeIllegalChars((String)r)).collect(Collectors.toList());
    }

    private boolean isUserIdDn() {
        return Boolean.parseBoolean(this.getConfigProperty(IS_USER_ID_DN, DEFAULT_USER_ID_DN));
    }

    private boolean escapeOn() {
        return Boolean.parseBoolean(this.getConfigProperty(LDAP_NAME_ESCAPE, "true"));
    }

    protected String escapeIllegalChars(String entityId) {
        if (!this.escapeOn()) {
            return entityId;
        }
        return entityId.replace(",", "\\,");
    }

    protected String unescapeIllegalChars(String entityId) {
        if (!this.escapeOn()) {
            return entityId;
        }
        return entityId.replace("\\,", ",");
    }
}

