/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.filter;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.filter.CoreFunction;
import org.dashbuilder.dataset.engine.filter.DataSetFilterAlgorithm;
import org.dashbuilder.dataset.engine.filter.DataSetFilterContext;
import org.dashbuilder.dataset.engine.filter.DataSetFunction;
import org.dashbuilder.dataset.engine.filter.LogicalFunction;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CustomFunctionFilter;
import org.dashbuilder.dataset.filter.LogicalExprFilter;

public class DefaultFilterAlgorithm
implements DataSetFilterAlgorithm {
    @Override
    public List<Integer> filter(DataSetHandler ctx, ColumnFilter columnFilter) {
        DataSet dataSet = ctx.getDataSet();
        DataSetFilterContext dataSetFilterContext = new DataSetFilterContext(dataSet);
        DataSetFunction filterFunction = this.buildFunction(dataSetFilterContext, columnFilter);
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (ctx == null || ctx.getRows() == null) {
            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                dataSetFilterContext.setCurrentRow(i);
                if (!filterFunction.pass()) continue;
                result.add(i);
            }
        } else {
            for (Integer targetRow : ctx.getRows()) {
                dataSetFilterContext.setCurrentRow(targetRow);
                if (!filterFunction.pass()) continue;
                result.add(targetRow);
            }
        }
        return result;
    }

    public DataSetFunction buildFunction(DataSetFilterContext filterContext, ColumnFilter columnFilter) {
        if (columnFilter instanceof LogicalExprFilter) {
            LogicalExprFilter filter = (LogicalExprFilter)columnFilter;
            LogicalFunction logicalFunction = new LogicalFunction(filterContext, filter);
            for (ColumnFilter filterTerm : filter.getLogicalTerms()) {
                DataSetFunction term = this.buildFunction(filterContext, filterTerm);
                logicalFunction.addFunctionTerm(term);
            }
            return logicalFunction;
        }
        if (columnFilter instanceof CoreFunctionFilter) {
            CoreFunctionFilter filter = (CoreFunctionFilter)columnFilter;
            return new CoreFunction(filterContext, filter);
        }
        if (columnFilter instanceof CustomFunctionFilter) {
            CustomFunctionFilter customFunctionFilter = (CustomFunctionFilter)columnFilter;
        }
        throw new IllegalArgumentException("Filter type not supported: " + columnFilter.getClass().getName());
    }
}

