/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.compiler.JavaConfiguration;

public enum JavaCompilerFactory {
    INSTANCE;

    private final Map classCache = new HashMap();

    public JavaCompiler loadCompiler(JavaConfiguration configuration) {
        return this.loadCompiler(configuration.getCompiler(), configuration.getJavaLanguageLevel());
    }

    public JavaCompiler loadCompiler(JavaConfiguration.CompilerType compilerType, String lngLevel) {
        return this.loadCompiler(compilerType, lngLevel, "");
    }

    public JavaCompiler loadCompiler(JavaConfiguration.CompilerType compilerType, String lngLevel, String sourceFolder) {
        JavaCompiler compiler = this.createCompiler(compilerType).orElseThrow(() -> new RuntimeException("Instance of " + (Object)((Object)compilerType) + " compiler cannot be created!"));
        compiler.setJavaCompilerSettings(this.createSettings(compiler, compilerType, lngLevel));
        compiler.setSourceFolder(sourceFolder);
        return compiler;
    }

    private JavaCompilerSettings createSettings(JavaCompiler compiler, JavaConfiguration.CompilerType compilerType, String lngLevel) {
        JavaCompilerSettings settings = compiler.createDefaultSettings();
        settings.setTargetVersion(lngLevel);
        if (compilerType == JavaConfiguration.CompilerType.ECLIPSE || lngLevel.startsWith("1.")) {
            settings.setSourceVersion(lngLevel);
        }
        return settings;
    }

    private Optional<JavaCompiler> createCompiler(JavaConfiguration.CompilerType compilerType) {
        return this.createCompiler(compilerType.getImplClassName());
    }

    private Optional<JavaCompiler> createCompiler(String className) {
        Class<?> clazz = (Class<?>)this.classCache.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                this.classCache.put(className, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            return Optional.of((JavaCompiler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }
}

