/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.EnabledBuilder;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.EntryPointBuilder;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.GroupElementBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.QueryBuilder;
import org.drools.compiler.rule.builder.ReturnValueBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleClassBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.SalienceBuilder;
import org.drools.core.addon.TypeResolver;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaConfiguration
implements DialectConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JavaConfiguration.class);
    protected static final String[] LANGUAGE_LEVELS = new String[]{"1.5", "1.6", "1.7", "1.8", "10", "11", "12", "13", "14", "15", "9"};
    private static final JavaConfiguration DEFAULT_JAVA_CONFIGURATION = new JavaConfiguration(new KnowledgeBuilderConfigurationImpl(JavaConfiguration.class.getClassLoader()));
    private static final String DEFAULT_JAVA_VERSION = JavaConfiguration.findJavaVersion(JavaConfiguration.DEFAULT_JAVA_CONFIGURATION.conf.getChainedProperties());
    protected static final transient Logger logger = LoggerFactory.getLogger(JavaConfiguration.class);
    public static final String JAVA_COMPILER_PROPERTY = "drools.dialect.java.compiler";
    public static final String JAVA_LANG_LEVEL_PROPERTY = "drools.dialect.java.compiler.lnglevel";
    private String languageLevel;
    private KnowledgeBuilderConfigurationImpl conf;
    private CompilerType compiler;

    public static JavaCompiler createDefaultCompiler() {
        return JavaCompilerFactory.INSTANCE.loadCompiler(DEFAULT_JAVA_CONFIGURATION.getCompiler(), DEFAULT_JAVA_VERSION, "src/main/java/");
    }

    public JavaConfiguration() {
    }

    public JavaConfiguration(KnowledgeBuilderConfigurationImpl conf) {
        this.init(conf);
    }

    @Override
    public void init(KnowledgeBuilderConfigurationImpl conf) {
        this.conf = conf;
        this.setCompiler(this.getDefaultCompiler());
        this.setJavaLanguageLevel(JavaConfiguration.findJavaVersion(conf.getChainedProperties()));
    }

    public static String findJavaVersion(ChainedProperties chainedProperties) {
        String level = chainedProperties.getProperty(JAVA_LANG_LEVEL_PROPERTY, System.getProperty("java.version"));
        if (level.startsWith("1.5")) {
            return "1.5";
        }
        if (level.startsWith("1.6")) {
            return "1.6";
        }
        if (level.startsWith("1.7")) {
            return "1.7";
        }
        if (level.startsWith("1.8")) {
            return "1.8";
        }
        if (level.startsWith("9")) {
            return "9";
        }
        if (level.startsWith("10")) {
            return "10";
        }
        return "11";
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getPackageBuilderConfiguration() {
        return this.conf;
    }

    @Override
    public Dialect newDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        return new DummyDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
    }

    public String getJavaLanguageLevel() {
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String languageLevel) {
        if (Arrays.binarySearch(LANGUAGE_LEVELS, languageLevel) < 0) {
            throw new RuntimeException("value '" + languageLevel + "' is not a valid language level");
        }
        this.languageLevel = languageLevel;
    }

    public void setCompiler(CompilerType compiler) {
        switch (compiler) {
            case ECLIPSE: {
                this.compiler = CompilerType.ECLIPSE;
                break;
            }
            case NATIVE: {
                this.compiler = CompilerType.NATIVE;
                break;
            }
            default: {
                throw new RuntimeException("value '" + (Object)((Object)compiler) + "' is not a valid compiler");
            }
        }
    }

    public boolean hasEclipseCompiler() {
        try {
            Class.forName(CompilerType.ECLIPSE.getImplClassName(), true, this.conf.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public CompilerType getCompiler() {
        return this.compiler;
    }

    private CompilerType getDefaultCompiler() {
        try {
            String prop = this.conf.getChainedProperties().getProperty(JAVA_COMPILER_PROPERTY, this.hasEclipseCompiler() ? "ECLIPSE" : "NATIVE");
            if (log.isDebugEnabled()) {
                log.debug("Selected compiler " + prop + " [drools.dialect.java.compiler:" + this.conf.getChainedProperties().getProperty(JAVA_COMPILER_PROPERTY, null) + ", hasEclipseCompiler:" + this.hasEclipseCompiler() + "]");
            }
            if (prop.equalsIgnoreCase("NATIVE")) {
                return CompilerType.NATIVE;
            }
            if (prop.equalsIgnoreCase("ECLIPSE")) {
                return CompilerType.ECLIPSE;
            }
            logger.error("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return CompilerType.ECLIPSE;
        }
        catch (SecurityException e) {
            logger.error("Drools config: unable to read the drools.compiler property. Using default.", (Throwable)e);
            return CompilerType.ECLIPSE;
        }
    }

    public static class DummyDialect
    implements Dialect {
        public static final String ID = "java";
        private final InternalKnowledgePackage pkg;
        private final ClassLoader rootClassLoader;
        private final KnowledgeBuilderConfigurationImpl pkgConf;
        private final PackageRegistry packageRegistry;

        DummyDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
            this.rootClassLoader = rootClassLoader;
            this.pkgConf = pkgConf;
            this.pkg = pkg;
            this.packageRegistry = pkgRegistry;
            JavaDialectRuntimeData data = (JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(ID);
            if (data == null) {
                data = new JavaDialectRuntimeData();
                this.pkg.getDialectRuntimeRegistry().setDialectData(ID, (DialectRuntimeData)data);
                data.onAdd(this.pkg.getDialectRuntimeRegistry(), rootClassLoader);
            } else {
                data = (JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(ID);
            }
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public PackageRegistry getPackageRegistry() {
            return this.packageRegistry;
        }

        @Override
        public void addImport(ImportDescr importDescr) {
        }

        @Override
        public void addStaticImport(ImportDescr importDescr) {
        }

        @Override
        public void init(RuleDescr ruleDescr) {
        }

        @Override
        public void init(ProcessDescr processDescr) {
        }

        @Override
        public EngineElementBuilder getBuilder(Class clazz) {
            if (clazz == PatternDescr.class) {
                return this.getPatternBuilder();
            }
            if (clazz == EntryPointDescr.class) {
                return this.getEntryPointBuilder();
            }
            if (clazz == AndDescr.class || clazz == OrDescr.class || clazz == NotDescr.class || clazz == ExistsDescr.class) {
                return new GroupElementBuilder();
            }
            return (EngineElementBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public PatternBuilder getPatternBuilder() {
            return new PatternBuilder();
        }

        @Override
        public EntryPointBuilder getEntryPointBuilder() {
            return new EntryPointBuilder();
        }

        @Override
        public TypeResolver getTypeResolver() {
            return this.packageRegistry.getTypeResolver();
        }

        @Override
        public String getExpressionDialectName() {
            return (String)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public Map<Class<?>, EngineElementBuilder> getBuilders() {
            return (Map)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public SalienceBuilder getSalienceBuilder() {
            return (SalienceBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public EnabledBuilder getEnabledBuilder() {
            return (EnabledBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public QueryBuilder getQueryBuilder() {
            return (QueryBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public RuleConditionBuilder getEvalBuilder() {
            return (RuleConditionBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public AccumulateBuilder getAccumulateBuilder() {
            return (AccumulateBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public PredicateBuilder getPredicateBuilder() {
            return (PredicateBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public ReturnValueBuilder getReturnValueBuilder() {
            return (ReturnValueBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public ConsequenceBuilder getConsequenceBuilder() {
            return (ConsequenceBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public RuleClassBuilder getRuleClassBuilder() {
            return (RuleClassBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public FromBuilder getFromBuilder() {
            return (FromBuilder)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
            return (AnalysisResult)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
            return (AnalysisResult)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public void compileAll() {
            CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public void addRule(RuleBuildContext context) {
            CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
            CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public List<KnowledgeBuilderResult> getResults() {
            return (List)CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public void clearResults() {
            CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
            CoreComponentsBuilder.throwExceptionForMissingMvel();
        }

        @Override
        public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
            CoreComponentsBuilder.throwExceptionForMissingMvel();
        }
    }

    public static enum CompilerType {
        ECLIPSE("org.drools.ecj.EclipseJavaCompiler"),
        NATIVE("org.drools.compiler.commons.jci.compilers.NativeJavaCompiler");

        private final String implClassName;

        private CompilerType(String implClassName) {
            this.implClassName = implClassName;
        }

        public String getImplClassName() {
            return this.implClassName;
        }
    }
}

